package ru.yandex.autotests.direct.api.ads.update.dynamictextad;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Banners;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Phrases;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 03.10.16.
 * https://st.yandex-team.ru/TESTIRT-10266
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Обновление объявления и проверка его состояния в базе")
@Issue("https://st.yandex-team.ru/DIRECT-58442")
public class UpdateAdsAndCheckDBTest {
    private static final String CLIENT = AdsLogins.CLIENT;
    private static Long adId;
    private static BannersRecord bannersBeforeUpdate;
    private static BannerImagesRecord bannerImagesBeforeUpdate;
    private static PhrasesRecord phrasesBeforeUpdate;
    private static BannersRecord bannersAfterUpdate;
    private static BannerImagesRecord bannerImagesAfterUpdate;
    private static PhrasesRecord phrasesAfterUpdate;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

    @BeforeClass
    public static void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        long sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        Long adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        String adImageHash = api.userSteps.imagesStepsV5().addDefaultRegularAdImage();
        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withAdGroupId(adGroupId)
                        .withDynamicTextAd(
                                new DynamicTextAdAddMap()
                                        .defaultDynamicTextAd()
                                        .withVCardId(vCardId)
                                        .withAdImageHash(adImageHash)
                                        .withSitelinkSetId(sitelinkSetId)
                                        .withAdExtensionIds(adExtensionId)
                        )
        );

        bannersBeforeUpdate = directJooqDbSteps.bannersSteps().getBanner(adId);
        bannerImagesBeforeUpdate = directJooqDbSteps.imagesSteps().getBannerImagesByBid(adId);
        phrasesBeforeUpdate = directJooqDbSteps.adGroupsSteps().getPhrases(adGroupId);

        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(adId)
                        .withDynamicTextAd(new DynamicTextAdUpdateMap().withText(DynamicTextAdAddMap.DEFAULT_TEXT + "Updated"))),
                ExpectedResult.success());

        bannersAfterUpdate = directJooqDbSteps.bannersSteps().getBanner(adId);
        bannerImagesAfterUpdate = directJooqDbSteps.imagesSteps().getBannerImagesByBid(adId);
        phrasesAfterUpdate = directJooqDbSteps.adGroupsSteps().getPhrases(adGroupId);
    }

    @Test
    public void checkPpcPhrasesAfterUpdateAd(){
        assertThat("в объявлении не изменилось ничего лишнего",
                phrasesAfterUpdate.intoMap(), beanDiffer(phrasesBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(Phrases.PHRASES.LASTCHANGE.getName())
                        )));
    }

    @Test
    public void checkPpcBannersAfterUpdateAd(){
        assertThat("в объявлении не изменилось ничего лишнего",
                bannersAfterUpdate.intoMap(), beanDiffer(bannersBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(Banners.BANNERS.LASTCHANGE.getName()),
                                BeanFieldPath.newPath(Banners.BANNERS.BODY.getName())
                        )));
    }

    @Test
    public void checkPpcBannerImagesAfterUpdateAd(){
        assertThat("в объявлении не изменилось ничего лишнего",
                bannerImagesAfterUpdate.intoMap(), beanDiffer(bannerImagesBeforeUpdate.intoMap()));
    }
}

