package ru.yandex.autotests.direct.api.ads.update.dynamictextad;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created by pavryabov on 01.12.15.
 * https://st.yandex-team.ru/TESTIRT-7862
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка обновления динамических текстовых объявлений")
@Issue("https://st.yandex-team.ru/DIRECT-43825")
@Tag(TagDictionary.TRUNK)
public class UpdateDynamicTextAdTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    private static final String NEW_TEXT = "SUPER_NEW_TEXT";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private long dynamicTextAdGroupId;
    private long adId;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();

        dynamicTextAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        adId = api.userSteps.adsSteps().addDefaultDynamicTextAd(dynamicTextAdGroupId);
    }

    @Test
    @Description("Обновить два динмаических текстовых объявления")
    public void updateTwoDynamicTextAds() {
        long anotherAdId = api.userSteps.adsSteps().addDefaultDynamicTextAd(dynamicTextAdGroupId);

        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(
                new AdUpdateItemMap()
                        .withId(adId)
                        .withDynamicTextAd(new DynamicTextAdUpdateMap()
                                .defaultDynamicTextAd()
                                .withText(NEW_TEXT)),
                new AdUpdateItemMap()
                        .withId(anotherAdId)
                        .withDynamicTextAd(new DynamicTextAdUpdateMap()
                                .defaultDynamicTextAd()
                                .withText(NEW_TEXT))),
                ExpectedResult.success(), ExpectedResult.success());

        List<BannersRecord> actualBanners = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN)
                .bannersSteps()
                .getBannersByCid(campaignId);

        List<String> actualBannerBodies = actualBanners.stream()
                .map(BannersRecord::getBody)
                .collect(Collectors.toList());

        assertThat("два динамических объявления были успешно обновлены",
                actualBannerBodies, equalTo(Arrays.asList(NEW_TEXT, NEW_TEXT)));
    }
}
