package ru.yandex.autotests.direct.api.ads.update.dynamictextad;

import java.util.Collection;
import java.util.stream.Collectors;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.cases.TextGeoMatchingCases;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 01.12.15.
 * https://st.yandex-team.ru/TESTIRT-7862
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Различный геотаргетинг и различный язык в тексте динамического " +
        "текстового объявления в запросе на его обновление")
@Issue("https://st.yandex-team.ru/DIRECT-43825")
@RunWith(Parameterized.class)
public class UpdateTextGeoTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long regionID;

    @Parameterized.Parameter(2)
    public String oldText;

    @Parameterized.Parameter(3)
    public String newText;

    @Parameterized.Parameter(4)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return TextGeoMatchingCases.getUpdateCases()
                .stream()
                .map(c -> new Object[]{c.description, c.regionId, c.oldText, c.newText, c.expectedResult})
                .collect(Collectors.toList());
    }

    private static Long campaignID;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignID = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
    }

    private long adID;

    @Before
    @Step("Подготовка данных для теста")
    public void createAdd() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        long adGroupID = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .withCampaignId(campaignID)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME)
                        .withRegionIds(regionID)
                        .withDefaultGroup(AdGroupType.DYNAMIC));
        adID = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupID)
                .withDynamicTextAd(new DynamicTextAdAddMap()
                        .defaultDynamicTextAd()
                        .withText(oldText)));
    }

    @Test
    public void updateAdText() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adID)
                                .withDynamicTextAd(new DynamicTextAdUpdateMap()
                                        .withText(newText))),
                expectedResult);
    }
}
