package ru.yandex.autotests.direct.api.ads.update.dynamictextad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.DynamicTextAdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 01.12.15.
 * https://st.yandex-team.ru/TESTIRT-7862
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка обновления визитной карточки объявлений")
@Issue("https://st.yandex-team.ru/DIRECT-43825")
@RunWith(Parameterized.class)
public class UpdateVCardTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adGroupID;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long oldVCardID;

    @Parameterized.Parameter(2)
    public Long newVCardID;

    @Parameterized.Parameter(3)
    public ProtocolType protocol;

    @Parameterized.Parameters(name = "{0}, protocol = {3}")
    public static Collection<Object[]> data() {
        api.protocol(ProtocolType.JSON);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long campaignID = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupID = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignID);
        long firstVCardID = api.userSteps.vCardsSteps().addDefaultVCard(campaignID);
        long secondVCardID = api.userSteps.vCardsSteps().addDefaultVCard(campaignID);

        return Arrays.asList(new Object[][]{
                {"Привязка визитной карточки к объявлению", null, firstVCardID, ProtocolType.JSON},
                {"Изменение визитной карточки в объявлении", firstVCardID, secondVCardID, ProtocolType.JSON},
                {"Отвязка визитной карточки от объявления", firstVCardID, null, ProtocolType.JSON},
                {"Отвязка визитной карточки от объявления", firstVCardID, null, ProtocolType.SOAP},
        });
    }

    private long adID;

    @Before
    @Step("Подготовка данных для теста")
    public void createAd() {
        api.protocol(ProtocolType.JSON);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        adID = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupID)
                .withDynamicTextAd(new DynamicTextAdAddMap()
                        .defaultDynamicTextAd()
                        .withVCardId(oldVCardID)));
    }

    @Test
    public void updateVCard() {
        api.protocol(protocol);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adID)
                                .withDynamicTextAd(new DynamicTextAdUpdateMap()
                                        .withVCardId(newVCardID))),
                ExpectedResult.success(adID));

        api.protocol(ProtocolType.JSON);
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID)
                .withDynamicTextAdFieldNames(DynamicTextAdFieldEnum.V_CARD_ID)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adID)));
        assertThat("визитная карточка в объявлении была успешно изменена", response.getAds(),
                beanEquivalentV5(Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withDynamicTextAd(new DynamicTextAdGetMap()
                                .withVCardId(newVCardID)).getBean())));
    }
}
