package ru.yandex.autotests.direct.api.ads.update.dynamictextad.calloutsetting;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.OperationEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 17.03.16.
 * https://st.yandex-team.ru/TESTIRT-8642
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка несоответствия языка в уточнениях и геотаргетинге группы")
@Issue("https://st.yandex-team.ru/DIRECT-50726")
@RunWith(Parameterized.class)
public class CalloutsGeoMatchingTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String calloutText;

    @Parameterized.Parameter(2)
    public Long groupRegionId;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Добавить уточнение с английским заголовком в английское объявление",
                        RandomStringUtils.random(15, RandomUtils.LATIN_CHARS) + "Vodka",
                        RegionIDValues.ENGLAND.getId().longValue(),
                        ExpectedResult.success()},
                {"Добавить уточнение с русским заголовком в русское объявление",
                        RandomStringUtils.random(15, RandomUtils.CYRILYC_CHARS) + "Водка",
                        RegionIDValues.RUSSIA.getId().longValue(),
                        ExpectedResult.success()},
                {"Добавить уточнение с украинским заголовком в украинское объявление",
                        RandomStringUtils.random(15, RandomUtils.UKRAIN_CHARS) + "Горілка",
                        RegionIDValues.UKRAINE.getId().longValue(),
                        ExpectedResult.success()},
                {"Добавить уточнение с турецким заголовком в турецкое объявление",
                        RandomStringUtils.random(15, RandomUtils.TURKEY_CHARS) + "türkiye",
                        RegionIDValues.TURKEY.getId().longValue(),
                        ExpectedResult.success()},
                {"Добавить уточнение с казахским заголовком в казахское объявление",
                        RandomStringUtils.random(15, RandomUtils.KAZAKH_CHARS) + "арақ",
                        RegionIDValues.KAZAKHSTAN.getId().longValue(),
                        ExpectedResult.success()},
                {"Добавить уточнение с заголовком с русскими и латинскими буквами в русское объявление",
                        RandomStringUtils.random(15, RandomUtils.LATIN_CHARS) + "Вод Vod",
                        RegionIDValues.RUSSIA.getId().longValue(),
                        ExpectedResult.success()},
                //after https://st.yandex-team.ru/DIRECT-53906
                {"Добавить уточнение с украинским заголовком в русское объявление",
                        RandomStringUtils.random(15, RandomUtils.UKRAIN_CHARS) + "Горілка",
                        RegionIDValues.RUSSIA.getId().longValue(),
                        ExpectedResult.success()},
                {"Добавить уточнение с турецким заголовком в русское объявление",
                        RandomStringUtils.random(15, RandomUtils.TURKEY_CHARS) + "türkiye",
                        RegionIDValues.RUSSIA.getId().longValue(),
                        ExpectedResult.success()},
                {"Добавить уточнение с казахским заголовком в русское объявление",
                        RandomStringUtils.random(15, RandomUtils.KAZAKH_CHARS) + "арақ",
                        RegionIDValues.RUSSIA.getId().longValue(),
                        ExpectedResult.success()},
        });
    }

    private static Long campaignId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
    }

    private Long adId;
    private Long adExtensionId;

    @Before
    @Step("Подготовка данных для теста")
    public void initMap() {
        Long adGroupId = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .withCampaignId(campaignId.longValue())
                .withName(AdGroupAddItemMap.DEFAULT_NAME)
                .withRegionIds(groupRegionId)
                .withDynamicTextAdGroup(new DynamicTextAdGroupMap().defaultGroup()));
        adId = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(calloutText);
    }

    @Test
    public void addEdExtensionIdToAd() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withDynamicTextAd(new DynamicTextAdUpdateMap()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(adExtensionId)
                                                        .withOperation(OperationEnum.ADD))))),
                expectedResult);
    }
}
