package ru.yandex.autotests.direct.api.ads.update.dynamictextad.calloutsetting;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.DynamicTextAdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 17.03.16.
 * https://st.yandex-team.ru/TESTIRT-8642
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка стирания уточнений в динамическом текстовом объявлении")
@Issue("https://st.yandex-team.ru/DIRECT-50726")
@RunWith(Parameterized.class)
public class UpdateAdWithNullInCalloutsTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId;
    private static Long adExtensionId;

    @Parameterized.Parameter(0)
    public ProtocolType protocol;

    @Parameterized.Parameters(name = "protocol = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {ProtocolType.JSON},
                {ProtocolType.SOAP},
        });
    }

    private Long adId;

    @BeforeClass
    public static void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createAd() {
        api.protocol(ProtocolType.JSON);
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withDynamicTextAd(new DynamicTextAdAddMap()
                        .defaultDynamicTextAd()
                        .withAdExtensionIds(adExtensionId)));
    }

    @Test
    public void updateAdExtensions() {
        api.protocol(protocol);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withDynamicTextAd(new DynamicTextAdUpdateMap()
                                        .withCalloutSetting(null))),
                ExpectedResult.success(adId));
        api.protocol(ProtocolType.JSON);
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID)
                .withDynamicTextAdFieldNames(DynamicTextAdFieldEnum.AD_EXTENSIONS)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId)));
        assertThat("уточнения в объявлении были успешно стерты", response.getAds(),
                beanDifferV5(Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withDynamicTextAd(new DynamicTextAdGetMap()).getBean())));
    }
}
