package ru.yandex.autotests.direct.api.ads.update.mobileappad;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.MobAppAgeLabelEnum;
import com.yandex.direct.api.v5.ads.MobileAppAdFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdGetMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 03.10.16.
 * https://st.yandex-team.ru/TESTIRT-10266
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Обновление мобильного объявления и проверка его состояния в ответе метода Get")
@Issue("https://st.yandex-team.ru/DIRECT-58442")
public class UpdateAdsAndCheckGetResponseTest {
    private static final String CLIENT = AdsLogins.CLIENT;
    private static Long adId;
    private static AdGetItem adsBeforeUpdate;
    private static AdGetItem adsAfterUpdate;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        String adImageHash = api.userSteps.imagesStepsV5().addDefaultWideAdImage();
        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withAdGroupId(adGroupId)
                        .withMobileAppAd(
                            new MobileAppAdAddMap()
                                .defaultMobileAppAd()
                                .withAdImageHash(adImageHash)
                                .withAgeLabel(MobAppAgeLabelEnum.AGE_16)
                        )
        );

        adsBeforeUpdate = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                    .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                    .withFieldNames(AdFieldEnum.class.getEnumConstants())
                    .withMobileAppAdFieldNames(MobileAppAdFieldEnum.class.getEnumConstants())).getAds().get(0);

        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(adId)
                        .withMobileAppAd(new MobileAppAdUpdateMap().withText(MobileAppAdAddMap.DEFAULT_TEXT + "Updated"))),
                ExpectedResult.success());

        adsAfterUpdate = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                        .withFieldNames(AdFieldEnum.class.getEnumConstants())
                        .withMobileAppAdFieldNames(MobileAppAdFieldEnum.class.getEnumConstants())).getAds().get(0);
    }

    @Test
    public void checkGetResponseAfterUpdateAds() {
        assertThat("в объявлении не изменилось ничего лишнего",
                adsAfterUpdate, beanDiffer(adsBeforeUpdate)
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(AdAddItemMap.MOBILE_APP_AD +"/"+ MobileAppAdGetMap.TEXT)
                        )));
    }
}
