package ru.yandex.autotests.direct.api.ads.update.mobileappad;

import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.ads.MobAppAgeLabelEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.lowerCase;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 29.09.15.
 * https://st.yandex-team.ru/TESTIRT-5113
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка возможности установить различные значения AgeLabel, используя метод update")
@Issue("https://st.yandex-team.ru/DIRECT-46329")
@RunWith(Parameterized.class)
public class UpdateMobileAppAdAgeLabelSaveToDatabaseTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public MobAppAgeLabelEnum ageLabel;

    @Parameterized.Parameter(1)
    public String expectedFlags;

    @Parameterized.Parameters(name = "AgeLabel = {0}")
    public static Iterable<Object[]> data() {
        return Stream.of(MobAppAgeLabelEnum.values())
                .map(ageLabel -> new Object[]{ageLabel, lowerCase(ageLabel.toString()).replace('_', ':')})
                .collect(Collectors.toList());
    }

    private static long adId;

    @BeforeClass
    public static void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(LOGIN);
        long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupId);
    }

    @Test
    public void addMobileAppAdWithAgeLabel() {
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                .withId(adId)
                .withMobileAppAd(new MobileAppAdUpdateMap()
                        .defaultMobileAppAd()
                        .withAgeLabel(ageLabel))));

        String actualFlags = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN)
                .bannersSteps()
                .getBanner(adId)
                .getFlags();

        assertThat( "флаги объявления соответствуют ожиданию", actualFlags, is(expectedFlags));
    }
}
