package ru.yandex.autotests.direct.api.ads.update.mobileappad;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasProperty;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@ParametersAreNonnullByDefault
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка изменения значения domain в БД у объявления с рекламой мобильных приложений при изменении трекинговой ссылки")
@Issue("https://st.yandex-team.ru/DIRECT-73996")
public class UpdateMobileAppAdDomainChangedTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    private static final String OLD_URL = "https://app.appsflyer.com/id313877526?pid=yandexdirect_int&" +
            "af_click_lookback=7d&c=Test&clickid={LOGID}&ios_ifa={IOSIFA}";
    private static final String OLD_DOMAIN = "app.appsflyer.com";
    private static final String NEW_URL = "https://redirect.appmetrica.yandex.com/serve/745636406096908737?click_id=" +
            "{LOGID}&ios_ifa_sha1={IDFA_LC_SH1}&search_term={keyword}&device_type={device_type}&region_name=" +
            "{region_name}&source_type={source_type}&phrase_id={phrase_id}&ios_ifa={IOSIFA}&source={source}&" +
            "position_type={position_type}&campaign_id={campaign_id}";
    private static final String NEW_DOMAIN = "redirect.appmetrica.yandex.com";


    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long adId;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(LOGIN);

        long mobileContentAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);

        AdAddItemMap adAddItemMap = new AdAddItemMap().withAdGroupId(mobileContentAdGroupId)
                .withMobileAppAd(new MobileAppAdAddMap().defaultMobileAppAd().withTrackingUrl(OLD_URL));

        adId = api.userSteps.adsSteps().addAd(adAddItemMap, null);

        BannersRecord ad = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).bannersSteps().getBanner(adId);

        assumeThat("у баннера ожидаемые значение href, domain",
                ad,
                allOf(
                        hasProperty("href", equalTo(OLD_URL)),
                        hasProperty("domain", equalTo(OLD_DOMAIN))));
    }

    @Test
    public void checkDomainOnTrackingUrlChange() {

        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap()
                .withAds(new AdUpdateItemMap()
                        .withId(adId)
                        .withMobileAppAd(new MobileAppAdUpdateMap()
                                .withTrackingUrl(NEW_URL))));

        BannersRecord ad = api.userSteps
                .getDirectJooqDbSteps()
                .useShardForLogin(LOGIN)
                .bannersSteps()
                .getBanner(adId);

        assertThat("у баннера изменились значения domain при смене href",
                ad,
                allOf(
                        hasProperty("href", equalTo(NEW_URL)),
                        hasProperty("domain", equalTo(NEW_DOMAIN))));
    }

}
