package ru.yandex.autotests.direct.api.ads.update.mobileappad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.MobileAppAdFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 23.03.16.
 * https://st.yandex-team.ru/TESTIRT-8629
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка обновления картинки в мобильном объявлении")
@Issue("https://st.yandex-team.ru/DIRECT-50153")
@RunWith(Parameterized.class)
public class UpdateMobileAppAdImageTest {

    private static final String LOGIN = AdsLogins.CLIENT29;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignID;
    private static Long adGroupId;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String oldAdImageHash;

    @Parameterized.Parameter(2)
    public String newAdImageHash;

    @Parameterized.Parameter(3)
    public ProtocolType protocol;

    @Parameterized.Parameters(name = "{0}, protocol = {3}")
    public static Collection<Object[]> data() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignID = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        String[] regularImageHashes = api.userSteps.imagesSteps().configLoginImages(LOGIN, ImageType.REGULAR, false,2, 3);
        String[] wideImageHashes = api.userSteps.imagesSteps().configLoginImages(LOGIN, ImageType.WIDE, false,2, 3);

        return Arrays.asList(new Object[][]{
                {"Привязка regular картинки к объявлению", null, regularImageHashes[0], ProtocolType.JSON},
                {"Привязка wide картинки к объявлению", null, wideImageHashes[0], ProtocolType.JSON},
                {"Изменение regular картинки в объявлении", regularImageHashes[0], regularImageHashes[1], ProtocolType.JSON},
                {"Изменение wide картинки в объявлении", wideImageHashes[0], wideImageHashes[1], ProtocolType.JSON},
                {"Изменение regular картинки в объявлении на wide", regularImageHashes[0], wideImageHashes[0], ProtocolType.JSON},
                {"Изменение wide картинки в объявлении на regular", wideImageHashes[0], regularImageHashes[0], ProtocolType.JSON},
                {"Отвязка картинки от объявления", regularImageHashes[0], null, ProtocolType.JSON},
                {"Отвязка картинки от объявления", regularImageHashes[0], null, ProtocolType.SOAP},
        });
    }

    private long adID;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignID);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createAd() {
        api.protocol(ProtocolType.JSON);
        adID = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withMobileAppAd(new MobileAppAdAddMap()
                        .defaultMobileAppAd()
                        .withAdImageHash(oldAdImageHash)));
    }

    @Test
    public void updateAdImage() {
        api.protocol(protocol);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adID)
                                .withMobileAppAd(new MobileAppAdUpdateMap()
                                        .withAdImageHash(newAdImageHash))),
                ExpectedResult.success(adID));

        api.protocol(ProtocolType.JSON);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adID))
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.AD_IMAGE_HASH));
        assertThat("картинка в объявлении была успешно изменена",
                getResponse.getAds().get(0).getMobileAppAd().getAdImageHash().getValue(), equalTo(newAdImageHash));
    }
}
