package ru.yandex.autotests.direct.api.ads.update.mobileappad;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created by semkagtn on 28.08.15.
 * https://st.yandex-team.ru/TESTIRT-6853
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка обновления объявлений с рекламой мобильных приложений")
@Issue("https://st.yandex-team.ru/DIRECT-44779")
@Tag(TagDictionary.TRUNK)
public class UpdateMobileAppAdTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    private static final String NEW_TITLE = "SUPER_NEW_TITLE";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;

    @BeforeClass
    public static void prepareStaticData() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    private Long campaignId;
    private long mobileContentAdGroupId;
    private long adId;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(LOGIN);

        mobileContentAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultMobileAppAd(mobileContentAdGroupId);
    }

    @Test
    @Description("Обновить два объявления с рекламой мобильных приложений")
    public void updateTwoMobileAppAds() {
        long anotherAdId = api.userSteps.adsSteps().addDefaultMobileAppAd(mobileContentAdGroupId);

        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(
                        new AdUpdateItemMap()
                                .withId(adId)
                                .withMobileAppAd(new MobileAppAdUpdateMap()
                                        .defaultMobileAppAd()
                                        .withTitle(NEW_TITLE)),
                        new AdUpdateItemMap()
                                .withId(anotherAdId)
                                .withMobileAppAd(new MobileAppAdUpdateMap()
                                        .defaultMobileAppAd()
                                        .withTitle(NEW_TITLE))),
                ExpectedResult.success(), ExpectedResult.success());

        List<BannersRecord> actualBanners = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN)
                .bannersSteps()
                .getBannersByCid(campaignId);

        List<String> actualBannerTitles = actualBanners.stream()
                .map(BannersRecord::getTitle)
                .collect(Collectors.toList());

        assertThat("два объявления с рекламой мобильных приложений были успешно обновлены",
                actualBannerTitles, equalTo(Arrays.asList(NEW_TITLE, NEW_TITLE)));
    }
}
