package ru.yandex.autotests.direct.api.ads.update.mobileappad;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.success;
import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.warnings;

@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-82971")
@Description("Проверка валидации трекинговой ссылки")
@RunWith(Parameterized.class)
public class UpdateMobileAppAdTrackingUrlNewRmpValidationTest {
    private static final String CLIENT = AdsLogins.CLIENT_NEW_RMP;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId;
    private Long adId;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String trackingUrl;

    @Parameterized.Parameter(2)
    public ExpectedResult result;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"With {logid}",
                        "https://app.appsflyer.com/112132123?pid=yandexdirect_int&clickid={logid}",
                        success()},
                {"Without {logid}",
                        "https://app.appsflyer.com/112132123?pid=yandexdirect_int",
                        warnings(new Notification(10250))},
                {"Without {logid} but for adjust",
                        "https://app.adjust.com/234234234234",
                        success()},
        });
    }

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
    }

    @Before
    public void before() {
        adId = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupId, CLIENT);
    }

    @Test
    public void addWithForbiddenTrackingUrl() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(adId)
                        .withMobileAppAd(new MobileAppAdUpdateMap().withTrackingUrl(trackingUrl))),
                result
        );
    }
}
