package ru.yandex.autotests.direct.api.ads.update.mobileappad;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.enums.TrustedRedirectsRedirectType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.db.steps.TrustedRedirectsSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.success;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.both;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.bothJavaAndPerl;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.expect;

/**
 * Created by ginger on 02.05.17.
 * https://st.yandex-team.ru/DIRECT-66001
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка валидации протокола и поддомена для TrackingUrl")
@Issue("https://st.yandex-team.ru/DIRECT-60699")
@RunWith(Parameterized.class)
public class UpdateMobileAppAdTrackingUrlTrustedRedirectsTest {
    private static Long adGroupId;
    private static DirectJooqDbSteps dbSteps;
    private static final String CLIENT = AdsLogins.CLIENT34;
    private static final String URL_WITH_ONLY_HTTPS_FLAG = "exam1.com/?clickid={LOGID}&ios_ifa={IOSIFA}";
    private static final String URL_WITH_ALLOW_WILDCARD_FLAG = "some.exam6.com/?clickid={LOGID}&ios_ifa={IOSIFA}";
    private static final String URL_WITH_ALLOW_WILDCARD_AND_ONLY_HTTPS_FLAG = "some.exam7.com/?clickid={LOGID}&ios_ifa={IOSIFA}";
    private static Long adId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String trackingUrl;

    @Parameterized.Parameter(2)
    public JavaOrPerlExpectedResult result;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"TrackingUrl помеченный флагом \"Только HTTPS\" c http",
                        "http://" + URL_WITH_ONLY_HTTPS_FLAG,
                        bothJavaAndPerl(5006, Api5ErrorDetails.THIS_TRACKING_SYSTEM_DOMAIN_ONLY_SUPPORTS_HTTPS)},
                {"TrackingUrl помеченный флагом \"Только HTTPS\" c https",
                        "https://" + URL_WITH_ONLY_HTTPS_FLAG,
                        both(success())},
                {"TrackingUrl помеченный флагом \"Разрешить субдомены\" с недопустимым субдоменом",
                        "https://a.b." + URL_WITH_ALLOW_WILDCARD_FLAG,
                        expect(5006,
                                Api5ErrorDetails.THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED,
                                Api5ErrorDetailsJava.THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED)},
                {"TrackingUrl помеченный флагом \"Разрешить субдомены\" с допустимым субдоменом 1го уровня",
                        "https://" + URL_WITH_ALLOW_WILDCARD_FLAG,
                        both(success())},
                {"TrackingUrl помеченный флагом \"Разрешить субдомены\" с допустимым субдоменом 2го уровня",
                        "https://a." + URL_WITH_ALLOW_WILDCARD_FLAG,
                        both(success())},
                {"TrackingUrl помеченный флагом \"Только HTTPS\" и флагом \"Разрешить субдомены\" c http",
                        "http://" + URL_WITH_ALLOW_WILDCARD_AND_ONLY_HTTPS_FLAG,
                        bothJavaAndPerl(5006, Api5ErrorDetails.THIS_TRACKING_SYSTEM_DOMAIN_ONLY_SUPPORTS_HTTPS)},
                {"TrackingUrl помеченный флагом \"Только HTTPS\" и флагом \"Разрешить субдомены\" c недопустимым субдоменом",
                        "http://a.b." + URL_WITH_ALLOW_WILDCARD_AND_ONLY_HTTPS_FLAG,
                        expect(5006,
                                Api5ErrorDetails.THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED,
                                Api5ErrorDetailsJava.THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED)},
                {"TrackingUrl помеченный флагом \"Только HTTPS\" и флагом \"Разрешить субдомены\" c https допустимым субдоменом",
                        "https://a." + URL_WITH_ALLOW_WILDCARD_AND_ONLY_HTTPS_FLAG,
                        both(success())},
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.as(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupId);
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
        dbSteps.trustedRedirectsSteps().saveTrustedRedirectsRecord(
                URL_WITH_ONLY_HTTPS_FLAG,
                TrustedRedirectsRedirectType.mobile_app_counter,
                TrustedRedirectsSteps.HTTPS_ONLY);
        dbSteps.trustedRedirectsSteps().saveTrustedRedirectsRecord(
                URL_WITH_ALLOW_WILDCARD_FLAG,
                TrustedRedirectsRedirectType.mobile_app_counter,
                TrustedRedirectsSteps.ALLOW_WILDCARD);
        dbSteps.trustedRedirectsSteps().saveTrustedRedirectsRecord(
                URL_WITH_ALLOW_WILDCARD_AND_ONLY_HTTPS_FLAG,
                TrustedRedirectsRedirectType.mobile_app_counter,
                TrustedRedirectsSteps.HTTPS_ONLY + "," + TrustedRedirectsSteps.ALLOW_WILDCARD);

    }

    @Test
    public void updateWithForbiddenTrackingUrl() {
        api.as(CLIENT).userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(adId)
                        .withMobileAppAd(new MobileAppAdUpdateMap().withTrackingUrl(trackingUrl))),
                result
        );
    }

}
