package ru.yandex.autotests.direct.api.ads.update.mobileappad;

import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.MobileAppAdFeatureItem;
import com.yandex.direct.api.v5.ads.MobileAppAdFieldEnum;
import com.yandex.direct.api.v5.ads.MobileAppFeatureEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsMobileContentRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.AdgroupsMobileContentUtils;
import ru.yandex.autotests.directapi.darkside.model.MobileContentUtils;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdFeatureItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 29.09.15.
 * https://st.yandex-team.ru/TESTIRT-6853
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка возможности отключения или включения значений Features")
@Issue("https://st.yandex-team.ru/DIRECT-44779")
@Tag(TagDictionary.TRUNK)
public class UpdateMobileAppDisableEnableFeaturesTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adGroupId;

    @BeforeClass
    public static void prepareStaticData() {
        String clientId = api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID();

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);

        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        jooqDbSteps.adGroupsSteps().setType(adGroupId, PhrasesAdgroupType.mobile_content);

        long mobileContentId =
                jooqDbSteps.mobileContentSteps().saveMobileContent(MobileContentUtils.getDefaultMobileContent(clientId));
        AdgroupsMobileContentRecord adgroupsMobileContentRecord =
                AdgroupsMobileContentUtils.getDefaultAdgroupsMobileContent(adGroupId, mobileContentId);
        jooqDbSteps.mobileContentSteps().saveAdgroupsMobileContent(adgroupsMobileContentRecord);
    }

    @Test
    @Description("Включить одну Feature")
    public void enableOneFeature() {
        long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withMobileAppAd(new MobileAppAdAddMap()
                        .defaultMobileAppAd()
                        .withFeatures(
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.CUSTOMER_RATING)
                                        .withEnabled(YesNoEnum.YES),
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.PRICE)
                                        .withEnabled(YesNoEnum.NO))));

        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                .withId(adId)
                .withMobileAppAd(new MobileAppAdUpdateMap()
                        .defaultMobileAppAd()
                        .withFeatures(new MobileAppAdFeatureItemMap()
                                .withFeature(MobileAppFeatureEnum.PRICE)
                                .withEnabled(YesNoEnum.YES)))));

        List<AdGetItem> ads = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.FEATURES)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId))).getAds();
        assumeThat("вернулось одно объявление", ads, hasSize(1));

        List<MobileAppFeatureEnum> features = ads.get(0).getMobileAppAd().getFeatures().stream()
                .filter(feature -> feature.getEnabled() == YesNoEnum.YES)
                .map(MobileAppAdFeatureItem::getFeature)
                .collect(Collectors.toList());

        assertThat("набор включенных Features соответствует ожидаемому",
                features, containsInAnyOrder(MobileAppFeatureEnum.PRICE, MobileAppFeatureEnum.CUSTOMER_RATING));
    }

    @Test
    @Description("Включить две Features")
    public void enableTwoFeatures() {
        long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withMobileAppAd(new MobileAppAdAddMap()
                        .defaultMobileAppAd()
                        .withFeatures(
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.CUSTOMER_RATING)
                                        .withEnabled(YesNoEnum.YES),
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.PRICE)
                                        .withEnabled(YesNoEnum.NO),
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.RATINGS)
                                        .withEnabled(YesNoEnum.NO))));

        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                .withId(adId)
                .withMobileAppAd(new MobileAppAdUpdateMap()
                        .defaultMobileAppAd()
                        .withFeatures(
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.PRICE)
                                        .withEnabled(YesNoEnum.YES),
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.RATINGS)
                                        .withEnabled(YesNoEnum.YES)))));

        List<AdGetItem> ads = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.FEATURES)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId))).getAds();
        assumeThat("вернулось одно объявление", ads, hasSize(1));

        List<MobileAppFeatureEnum> features = ads.get(0).getMobileAppAd().getFeatures().stream()
                .filter(feature -> feature.getEnabled() == YesNoEnum.YES)
                .map(MobileAppAdFeatureItem::getFeature)
                .collect(Collectors.toList());

        assertThat("набор включенных Features соответствует ожидаемому",
                features, containsInAnyOrder(MobileAppFeatureEnum.CUSTOMER_RATING,
                        MobileAppFeatureEnum.PRICE, MobileAppFeatureEnum.RATINGS));
    }

    @Test
    @Description("Отключить одну Feature")
    public void disableOneFeature() {
        long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withMobileAppAd(new MobileAppAdAddMap()
                        .defaultMobileAppAd()
                        .withFeatures(
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.CUSTOMER_RATING)
                                        .withEnabled(YesNoEnum.YES),
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.PRICE)
                                        .withEnabled(YesNoEnum.YES))));

        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                .withId(adId)
                .withMobileAppAd(new MobileAppAdUpdateMap()
                        .defaultMobileAppAd()
                        .withFeatures(new MobileAppAdFeatureItemMap()
                                .withFeature(MobileAppFeatureEnum.CUSTOMER_RATING)
                                .withEnabled(YesNoEnum.NO)))));

        List<AdGetItem> ads = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.FEATURES)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId))).getAds();
        assumeThat("вернулось одно объявление", ads, hasSize(1));

        List<MobileAppFeatureEnum> features = ads.get(0).getMobileAppAd().getFeatures().stream()
                .filter(feature -> feature.getEnabled() == YesNoEnum.YES)
                .map(MobileAppAdFeatureItem::getFeature)
                .collect(Collectors.toList());

        assertThat("набор включенных Features соответствует ожидаемому",
                features, contains(MobileAppFeatureEnum.PRICE));
    }

    @Test
    @Description("Отключить две Features")
    public void disableTwoFeatures() {
        long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withMobileAppAd(new MobileAppAdAddMap()
                        .defaultMobileAppAd()
                        .withFeatures(
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.CUSTOMER_RATING)
                                        .withEnabled(YesNoEnum.YES),
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.PRICE)
                                        .withEnabled(YesNoEnum.YES),
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.RATINGS)
                                        .withEnabled(YesNoEnum.YES))));

        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                .withId(adId)
                .withMobileAppAd(new MobileAppAdUpdateMap()
                        .defaultMobileAppAd()
                        .withFeatures(
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.CUSTOMER_RATING)
                                        .withEnabled(YesNoEnum.NO),
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.PRICE)
                                        .withEnabled(YesNoEnum.NO)))));

        List<AdGetItem> ads = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.FEATURES)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId))).getAds();
        assumeThat("вернулось одно объявление", ads, hasSize(1));

        List<MobileAppFeatureEnum> features = ads.get(0).getMobileAppAd().getFeatures().stream()
                .filter(feature -> feature.getEnabled() == YesNoEnum.YES)
                .map(MobileAppAdFeatureItem::getFeature)
                .collect(Collectors.toList());

        assertThat("набор включенных Features соответствует ожидаемому",
                features, contains(MobileAppFeatureEnum.RATINGS));
    }

    @Test
    @Description("Включить одну Feature и выключить одну Feature за один запрос")
    public void enableOneAndDisableOneFeatures() {
        long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withMobileAppAd(new MobileAppAdAddMap()
                        .defaultMobileAppAd()
                        .withFeatures(
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.CUSTOMER_RATING)
                                        .withEnabled(YesNoEnum.YES),
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.PRICE)
                                        .withEnabled(YesNoEnum.NO),
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.RATINGS)
                                        .withEnabled(YesNoEnum.NO))));

        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                .withId(adId)
                .withMobileAppAd(new MobileAppAdUpdateMap()
                        .defaultMobileAppAd()
                        .withFeatures(
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.CUSTOMER_RATING)
                                        .withEnabled(YesNoEnum.NO),
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.PRICE)
                                        .withEnabled(YesNoEnum.YES)))));

        List<AdGetItem> ads = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.FEATURES)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId))).getAds();
        assumeThat("вернулось одно объявление", ads, hasSize(1));

        List<MobileAppFeatureEnum> features = ads.get(0).getMobileAppAd().getFeatures().stream()
                .filter(feature -> feature.getEnabled() == YesNoEnum.YES)
                .map(MobileAppAdFeatureItem::getFeature)
                .collect(Collectors.toList());

        assertThat("набор включенных Features соответствует ожидаемому",
                features, contains(MobileAppFeatureEnum.PRICE));
    }

    @Test
    @Description("Выключить уже выключенную Feature")
    public void disableDisabledFeature() {
        long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withMobileAppAd(new MobileAppAdAddMap()
                        .defaultMobileAppAd()
                        .withFeatures(
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.CUSTOMER_RATING)
                                        .withEnabled(YesNoEnum.YES),
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.PRICE)
                                        .withEnabled(YesNoEnum.NO),
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.RATINGS)
                                        .withEnabled(YesNoEnum.NO))));

        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                .withId(adId)
                .withMobileAppAd(new MobileAppAdUpdateMap()
                        .defaultMobileAppAd()
                        .withFeatures(
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.PRICE)
                                        .withEnabled(YesNoEnum.NO)))));

        List<AdGetItem> ads = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.FEATURES)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId))).getAds();
        assumeThat("вернулось одно объявление", ads, hasSize(1));

        List<MobileAppFeatureEnum> features = ads.get(0).getMobileAppAd().getFeatures().stream()
                .filter(feature -> feature.getEnabled() == YesNoEnum.YES)
                .map(MobileAppAdFeatureItem::getFeature)
                .collect(Collectors.toList());

        assertThat("набор включенных Features соответствует ожидаемому",
                features, contains(MobileAppFeatureEnum.CUSTOMER_RATING));
    }

    @Test
    @Description("Включить уже выключенную Feature")
    public void enableEnabledFeature() {
        long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withMobileAppAd(new MobileAppAdAddMap()
                        .defaultMobileAppAd()
                        .withFeatures(
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.CUSTOMER_RATING)
                                        .withEnabled(YesNoEnum.YES),
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.PRICE)
                                        .withEnabled(YesNoEnum.NO),
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.RATINGS)
                                        .withEnabled(YesNoEnum.NO))));

        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                .withId(adId)
                .withMobileAppAd(new MobileAppAdUpdateMap()
                        .defaultMobileAppAd()
                        .withFeatures(
                                new MobileAppAdFeatureItemMap()
                                        .withFeature(MobileAppFeatureEnum.CUSTOMER_RATING)
                                        .withEnabled(YesNoEnum.YES)))));

        List<AdGetItem> ads = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.FEATURES)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId))).getAds();
        assumeThat("вернулось одно объявление", ads, hasSize(1));

        List<MobileAppFeatureEnum> features = ads.get(0).getMobileAppAd().getFeatures().stream()
                .filter(feature -> feature.getEnabled() == YesNoEnum.YES)
                .map(MobileAppAdFeatureItem::getFeature)
                .collect(Collectors.toList());

        assertThat("набор включенных Features соответствует ожидаемому",
                features, contains(MobileAppFeatureEnum.CUSTOMER_RATING));
    }
}
