package ru.yandex.autotests.direct.api.ads.update.mobileappadbuilderad;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PerfCreativesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdBuilderAdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdBuilderAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.VideoExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.VideoExtensionUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.Common.fieldMustBePositiveInteger;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.bothJavaAndPerl;

/**
 https://st.yandex-team.ru/DIRECT-71573
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка работы поля CreativeId")
@Issue("https://st.yandex-team.ru/DIRECT-58369")
@RunWith(Parameterized.class)
public class UpdateMobileAppAdBuilderAdCreativeValidationNegativeTest {
    private static String LOGIN = AdsLogins.CLIENT;
    private static Long NEGATIVE_ID = -1L;
    private static Long ZERO_ID = 0L;
    private static Long ANOTHER_CLIENT_CREATIVE_ID = 123L;
    private static Long adGroupId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long adId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public AdBuilderAdUpdateItemMap creative;

    @Parameterized.Parameter(1)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(LOGIN);
        Long creativeIdWithAnotherSize = directJooqDbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                        Long.parseLong(User.get(LOGIN).getClientID()));
        PerfCreativesRecord creativeWithAnotherSize = directJooqDbSteps.perfCreativesSteps().getPerfCreatives(creativeIdWithAnotherSize);
        short updatedWidth = (short) (creativeWithAnotherSize.getWidth() + 1);
        creativeWithAnotherSize.setWidth(updatedWidth);
        directJooqDbSteps.perfCreativesSteps().updatePerfCreatives(creativeWithAnotherSize);

        Object[][] data = new Object[][]{
                {new AdBuilderAdUpdateItemMap().withCreativeId(NEGATIVE_ID),
                        fieldMustBePositiveInteger(capitalize(VideoExtensionAddItemMap.CREATIVE_ID))},
                {new AdBuilderAdUpdateItemMap().withCreativeId(ZERO_ID),
                        fieldMustBePositiveInteger(capitalize(VideoExtensionAddItemMap.CREATIVE_ID))},
                {new AdBuilderAdUpdateItemMap().withCreativeId(ANOTHER_CLIENT_CREATIVE_ID),
                        bothJavaAndPerl(8800, Api5ErrorDetails.CREATIVE_NOT_FOUND)},
                {new AdBuilderAdUpdateItemMap(),
                        fieldMustBePositiveInteger(capitalize(VideoExtensionUpdateItemMap.CREATIVE_ID))},
                {new AdBuilderAdUpdateItemMap().withCreativeId(creativeIdWithAnotherSize),
                        bothJavaAndPerl(6000, Api5ErrorDetails.NEW_AND_OLD_IMAGES_MUST_BE_SAME_SIZE)},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void addCampaign(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(LOGIN);
        Long creativeId = directJooqDbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                Long.parseLong(User.get(LOGIN).getClientID()));
        adId = api.userSteps.adsSteps().addDefaultMobileAppAdBuilderAd(adGroupId, creativeId);

    }

    @Test
    public void updateMobileAppAdBuilderAd() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(
                        new AdUpdateItemMap()
                                .withMobileAppAdBuilderAd(
                                        new MobileAppAdBuilderAdUpdateMap()
                                                .withCreative(creative))
                                .withId(adId)),
                expectedResult
        );
    }
}



