package ru.yandex.autotests.direct.api.ads.update.mobileappadbuilderad;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdBuilderAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/DIRECT-71573
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка работы поля CreativeId")
@Issue("https://st.yandex-team.ru/DIRECT-58369")
@RunWith(Parameterized.class)
public class UpdateMobileAppAdBuilderAdCreativeValidationPositiveTest {
    private static String LOGIN = AdsLogins.CLIENT;
    private static String REP_LOGIN = AdsLogins.CLIENT_REP;
    private static Long adId;
    private static Long adGroupId;
    private static Long creativeId;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {LOGIN},
                {REP_LOGIN}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void addCamp(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN).perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                        Long.parseLong(User.get(LOGIN).getClientID()));
        api.as(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultMobileAppAdBuilderAd(adGroupId, creativeId);


    }

    @Test
    public void updateMobileAppAdBuilderAd() {
        api.as(loginForAuthorization).userSteps.adsSteps().adsUpdate(
                new UpdateRequestMap().withAds(
                    new AdUpdateItemMap()
                        .withMobileAppAdBuilderAd(
                                new MobileAppAdBuilderAdUpdateMap()
                                        .withCreative(creativeId))
                        .withId(adId))
        );
        List<Long> creativeIds = api.userSteps.getDirectJooqDbSteps().useShardForLogin(loginForAuthorization)
                .bannersPerformanceSteps().findCreativeIds(adId);
        assumeThat("получена одна запись", creativeIds, hasSize(1));
        assertThat("получена ожидаемая связка из banner_performance", creativeIds.get(0), equalTo(creativeId));
    }
}


