package ru.yandex.autotests.direct.api.ads.update.mobileappadbuilderad;

import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsHrefValidationHelper;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdBuilderAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * https://st.yandex-team.ru/DIRECT-71573
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка валидации поля Href. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-58369")
@RunWith(Parameterized.class)
public class UpdateMobileAppAdBuilderAdUrlValidationPositiveTest {
    static String CLIENT = AdsLogins.CLIENT40;
    private static Long adGroupId;
    private static DirectJooqDbSteps dbSteps;
    private static Long creativeId;
    private static Long adId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String href;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return AdsHrefValidationHelper.getHrefDataForPositiveParameterized();
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);
        creativeId = dbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                        Long.parseLong(User.get(CLIENT).getClientID()));
        api.as(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultMobileAppAdBuilderAd(adGroupId, creativeId);
    }

    @Test
    public void updateWithTrackingUrl() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(
                        new AdUpdateItemMap().withMobileAppAdBuilderAd(
                                new MobileAppAdBuilderAdUpdateMap().withCreative(creativeId)
                        ).withId(adId)
                ),
                ExpectedResult.success()
        );
        assertThat("трекинговая ссылка сохранилась верно",
                dbSteps.bannersSteps().getBanner(adId).getHref(),
                equalTo(MobileAppAdBuilderAdAddMap.DEFAULT_TRACKING_URL));
    }
}
