package ru.yandex.autotests.direct.api.ads.update.mobileappcpcvideoadbuilderad;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Banners;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.BannersPerformance;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Phrases;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersPerformanceRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppCpcVideoAdBuilderAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Обновление видео-объявлени и проверка его состояния в базе")
@Issue("https://st.yandex-team.ru/DIRECT-132279")
@Tag(TagDictionary.TRUNK)
public class UpdateMobileAppCpcVideoBuilderAdCheckDbTest {
    private static final String CLIENT = AdsLogins.CLIENT;
    private static PhrasesRecord phrasesBeforeUpdate;
    private static PhrasesRecord phrasesAfterUpdate;
    private static BannersRecord bannersBeforeUpdate;
    private static BannersRecord bannersAfterUpdate;
    private static BannersPerformanceRecord bannerPerformanceAfterUpdate;
    private static BannersPerformanceRecord bannerPerformanceBeforeUpdate;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

    @BeforeClass
    public static void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        Long clientId = Long.parseLong(User.get(CLIENT).getClientID());
        Long creativeIdForAdd = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).perfCreativesSteps()
                .saveDefaultCpcVideoCreative(clientId);

        Long adId = api.userSteps.adsSteps().addDefaultMobileAppCpcVideoAdBuilderAd(adGroupId, creativeIdForAdd);

        bannerPerformanceBeforeUpdate =
                directJooqDbSteps.bannersPerformanceSteps().getBannersPerformance(adId, creativeIdForAdd);
        bannersBeforeUpdate = directJooqDbSteps.bannersSteps().getBanner(adId);
        phrasesBeforeUpdate = directJooqDbSteps.adGroupsSteps().getPhrases(adGroupId);

        Long creativeIdForUpdate = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).perfCreativesSteps()
                .saveDefaultCpcVideoCreative(clientId);

        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(adId)
                        .withMobileAppCpcVideoAdBuilderAd(new MobileAppCpcVideoAdBuilderAdUpdateMap()
                                .withCreative(creativeIdForUpdate))),
                ExpectedResult.success());

        bannerPerformanceAfterUpdate =
                directJooqDbSteps.bannersPerformanceSteps().getBannersPerformance(adId, creativeIdForUpdate);
        bannersAfterUpdate = directJooqDbSteps.bannersSteps().getBanner(adId);
        phrasesAfterUpdate = directJooqDbSteps.adGroupsSteps().getPhrases(adGroupId);
    }

    @Test
    public void checkPhrasesAfterUpdateAd() {
        assertThat("в объявлении не изменилось ничего лишнего",
                phrasesAfterUpdate.intoMap(), beanDiffer(phrasesBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(Phrases.PHRASES.LASTCHANGE.getName())
                        )));
    }

    @Test
    public void checkBannersAfterUpdateAd() {
        assertThat("в объявлении не изменилось ничего лишнего",
                bannersAfterUpdate.intoMap(), beanDiffer(bannersBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(Banners.BANNERS.LASTCHANGE.getName())
                        )));
    }

    @Test
    public void checkBannerPerformanceAfterUpdateAd() {
        assertThat("в объявлении не изменилось ничего лишнего",
                bannerPerformanceBeforeUpdate.intoMap(), beanDiffer(bannerPerformanceAfterUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(BannersPerformance.BANNERS_PERFORMANCE.CREATIVE_ID.getName())
                        )));
    }

}
