package ru.yandex.autotests.direct.api.ads.update.mobileappcpcvideoadbuilderad;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PerfCreativesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdBuilderAdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppCpcVideoAdBuilderAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.Common.fieldMustBePositiveInteger;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.bothJavaAndPerl;

@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка работы поля CreativeId. Негативные сценарии.")
@Issue("https://st.yandex-team.ru/DIRECT-132279")
@RunWith(Parameterized.class)
public class UpdateMobileAppCpcVideoBuilderAdCreativeValidationNegativeTest {
    private static final String CLIENT = AdsLogins.CLIENT;
    private static final Long NEGATIVE_ID = -1L;
    private static final Long ZERO_ID = 0L;
    private static final Long ANOTHER_CLIENT_CREATIVE_ID = 123L;
    private static Long adId;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public AdBuilderAdUpdateItemMap creative;

    @Parameterized.Parameter(1)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        DirectJooqDbSteps directJooqDbSteps =
                api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);
        Long creativeIdWithAnotherSize = directJooqDbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                Long.parseLong(User.get(CLIENT).getClientID()));
        PerfCreativesRecord creativeWithAnotherSize =
                directJooqDbSteps.perfCreativesSteps().getPerfCreatives(creativeIdWithAnotherSize);
        short updatedWidth = (short) (creativeWithAnotherSize.getWidth() + 1);
        creativeWithAnotherSize.setWidth(updatedWidth);
        directJooqDbSteps.perfCreativesSteps().updatePerfCreatives(creativeWithAnotherSize);

        Object[][] data = new Object[][]{
                {new AdBuilderAdUpdateItemMap().withCreativeId(NEGATIVE_ID),
                        fieldMustBePositiveInteger(capitalize(AdBuilderAdUpdateItemMap.CREATIVE_ID))},

                {new AdBuilderAdUpdateItemMap().withCreativeId(ZERO_ID),
                        fieldMustBePositiveInteger(capitalize(AdBuilderAdUpdateItemMap.CREATIVE_ID))},

                {new AdBuilderAdUpdateItemMap(),
                        fieldMustBePositiveInteger(capitalize(AdBuilderAdUpdateItemMap.CREATIVE_ID))},

                {new AdBuilderAdUpdateItemMap().withCreativeId(ANOTHER_CLIENT_CREATIVE_ID),
                        bothJavaAndPerl(8800, Api5ErrorDetails.CPC_VIDEO_NOT_FOUND)},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long creativeId = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).perfCreativesSteps()
                .saveDefaultCpcVideoCreative(Long.parseLong(User.get(CLIENT).getClientID()));

        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultMobileAppCpcVideoAdBuilderAd(adGroupId, creativeId);

    }

    @Test
    public void updateMobileAppCpcVideoAdBuilderAd() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withMobileAppCpcVideoAdBuilderAd(new MobileAppCpcVideoAdBuilderAdUpdateMap()
                                        .withCreative(creative))
                                .withId(adId)),
                expectedResult);
    }
}
