package ru.yandex.autotests.direct.api.ads.update.mobileappcpcvideoadbuilderad;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppCpcVideoAdBuilderAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка обновления и валидации TrackingUrl в видео-объявлении РМП")
@Issue("https://st.yandex-team.ru/DIRECT-132279")
public class UpdateMobileAppCpcVideoBuilderAdTrackingUrlTest {
    private static final String CLIENT = AdsLogins.CLIENT45;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId;
    private static DirectJooqDbSteps dbSteps;


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);

        Long creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(CLIENT).perfCreativesSteps().saveDefaultCpcVideoCreative(
                        Long.parseLong(User.get(CLIENT).getClientID()));

        adId = api.userSteps.adsSteps().addDefaultMobileAppCpcVideoAdBuilderAd(adGroupId, creativeId);
    }

    @Test
    public void updateWithTrackingUrl() {
        String newTrackingUrl = "http://appmetrica.yandex.com";
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(
                        new AdUpdateItemMap().withMobileAppCpcVideoAdBuilderAd(
                                new MobileAppCpcVideoAdBuilderAdUpdateMap()
                                        .withTrackingUrl(newTrackingUrl)
                        ).withId(adId)
                ),
                ExpectedResult.success()
        );
        assertThat("трекинговая ссылка обновилась верно",
                dbSteps.bannersSteps().getBanner(adId).getHref(), equalTo(newTrackingUrl));
    }

    @Test
    public void updateWithoutTrackingUrl() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(
                        new AdUpdateItemMap().withMobileAppCpcVideoAdBuilderAd(
                                new MobileAppCpcVideoAdBuilderAdUpdateMap()
                                        .withTrackingUrl(null)
                        ).withId(adId)
                ),
                ExpectedResult.success()
        );
        assertThat("трекинговая ссылка обновилась верно",
                dbSteps.bannersSteps().getBanner(adId).getHref(), equalTo(null));
    }
}
