package ru.yandex.autotests.direct.api.ads.update.mobileappimagead;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppImageAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * Created by gerdler on 13.07.16.
 * https://st.yandex-team.ru/TESTIRT-9322
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка обновления и валидации TrackingUrl в графических баннерах РМП")
@Issue("https://st.yandex-team.ru/DIRECT-54754")
public class UpdateMobileAppImageAdTrackingUrlTest {
    private static String client = AdsLogins.CLIENT45;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId;
    private static DirectJooqDbSteps dbSteps;


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        String adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(1);
        dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(client);
        adId = api.userSteps.adsSteps().addDefaultMobileAppImageAd(adGroupId, adImageHash);
    }

    @Test
    public void updateWithTrackingUrl() {
        String newTrackingUrl = "http://appmetrica.yandex.com";
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(
                        new AdUpdateItemMap().withMobileAppImageAd(
                                new MobileAppImageAdUpdateMap().withTrackingUrl(newTrackingUrl)
                        ).withId(adId)
                ),
                ExpectedResult.success()
        );
        assertThat("трекинговая ссылка обновилась верно",
                dbSteps.bannersSteps().getBanner(adId).getHref(), equalTo(newTrackingUrl));
    }

    @Test
    public void updateWithNilTrackingUrl() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(
                        new AdUpdateItemMap().withMobileAppImageAd(
                                new MobileAppImageAdUpdateMap().withTrackingUrl(null)
                        ).withId(adId)
                ),
                ExpectedResult.success()
        );
        assertThat("трекинговая ссылка обновилась верно",
                dbSteps.bannersSteps().getBanner(adId).getHref(), equalTo(null));
    }
}
