package ru.yandex.autotests.direct.api.ads.update.textad;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinkMap;
import ru.yandex.autotests.directapi.model.api5.sitelinks.SitelinksSetAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 13.10.15.
 * https://st.yandex-team.ru/TESTIRT-7422
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка несоответствия языка в заголовке сайтлинков и геотаргетинге группы")
@Issue("https://st.yandex-team.ru/DIRECT-47003")
@RunWith(Parameterized.class)
public class SitelinksGeoMatchingTitleTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String sitelinkTitle;

    @Parameterized.Parameter(2)
    public Long groupRegionId;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Добавить сайтлинк с английским заголовком в английское объявление",
                        "Vodka",
                        RegionIDValues.ENGLAND.getId().longValue(),
                        ExpectedResult.success()},
                {"Добавить сайтлинк с русским заголовком в русское объявление",
                        "Водка",
                        RegionIDValues.RUSSIA.getId().longValue(),
                        ExpectedResult.success()},
                {"Добавить сайтлинк с украинским заголовком в украинское объявление",
                        "Горілка",
                        RegionIDValues.UKRAINE.getId().longValue(),
                        ExpectedResult.success()},
                {"Добавить сайтлинк с турецким заголовком в турецкое объявление",
                        "türkiye",
                        RegionIDValues.TURKEY.getId().longValue(),
                        ExpectedResult.success()},
                {"Добавить сайтлинк с казахским заголовком в казахское объявление",
                        "арақ",
                        RegionIDValues.KAZAKHSTAN.getId().longValue(),
                        ExpectedResult.success()},
                {"Добавить сайтлинк с заголовком с русскими и латинскими буквами в русское объявление",
                        "Водка Vodka",
                        RegionIDValues.RUSSIA.getId().longValue(),
                        ExpectedResult.success()},
                //after https://st.yandex-team.ru/DIRECT-53906
                {"Добавить сайтлинк с украинским заголовком в русское объявление",
                        "Горілка",
                        RegionIDValues.RUSSIA.getId().longValue(),
                        ExpectedResult.success()},
                {"Добавить сайтлинк с турецким заголовком в русское объявление",
                        "türkiye",
                        RegionIDValues.RUSSIA.getId().longValue(),
                        ExpectedResult.success()},
                {"Добавить сайтлинк с казахским заголовком в русское объявление",
                        "арақ",
                        RegionIDValues.RUSSIA.getId().longValue(),
                        ExpectedResult.success()},
        });
    }

    private static Long campaignId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
    }

    private Long adId;
    private Long sitelinksSetId;

    @Before
    @Step("Подготовка данных для теста")
    public void initMap() {
        Long adGroupId = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .withCampaignId(campaignId)
                .withName(AdGroupAddItemMap.DEFAULT_NAME)
                .withRegionIds(groupRegionId));
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);

        List<Long> sitelinksSetIds = api.userSteps.sitelinksSteps().add(
                new ru.yandex.autotests.directapi.model.api5.sitelinks.AddRequestMap()
                        .withSitelinksSets(new SitelinksSetAddItemMap()
                                .withSitelinks(new SitelinkMap()
                                        .randomSitelink()
                                        .withTitle(sitelinkTitle))));
        assumeThat("был создан один набор сайтлинков", sitelinksSetIds, hasSize(1));
        sitelinksSetId = sitelinksSetIds.get(0);
    }

    @Test
    public void updateSitelinksSet() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .withSitelinkSetId(sitelinksSetId))),
                expectedResult);
    }
}
