package ru.yandex.autotests.direct.api.ads.update.textad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AgeLabelEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.api.ads.AdsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by samedy on 18.12.15.
 * https://st.yandex-team.ru/TESTIRT-8062
 */

@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Stories(AdsStories.TEXT_AD)
@Description("Изменение значения поля AgeLabel при обновлении текстового объявления")
@RunWith(Parameterized.class)
public class UpdateAgeLabelNegativeTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adID;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public AgeLabelEnum oldAgeLabel;

    @Parameterized.Parameter(2)
    public AgeLabelEnum newAgeLabel;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"изменение значения AgeLabel с месяцев на года",
                        AgeLabelEnum.MONTHS_6,
                        AgeLabelEnum.AGE_6,
                        ExpectedResult.errors(new Notification(6000, Api5ErrorDetails.ALLOWED_TO_INSTALL_ONLY_MONTH_N))},

                {"изменение значения AgeLabel с лет на месяцы",
                        AgeLabelEnum.AGE_6,
                        AgeLabelEnum.MONTHS_1,
                        ExpectedResult.errors(new Notification(6000, Api5ErrorDetails.ALLOWED_TO_INSTALL_ONLY_AGE_N))},
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        api.as(Logins.SUPER_LOGIN);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, LOGIN);
        adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID, LOGIN);
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(
                new AdUpdateItemMap().withId(adID)
                        .withTextAd(new TextAdUpdateMap().defaultAd().withAgeLabel(oldAgeLabel))),
                LOGIN);

        api.as(LOGIN);
    }

    @Test
    public void updateAgeLabel() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adID)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withAgeLabel(newAgeLabel))),
                expectedResult);
    }
}
