package ru.yandex.autotests.direct.api.ads.update.textad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AgeLabelEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.api.ads.AdsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 17.04.15.
 * https://st.yandex-team.ru/TESTIRT-5113
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Stories(AdsStories.TEXT_AD)
@Description("Изменение значения поля AgeLabel при обновлении текстового объявления от имени разных ролей")
@RunWith(Parameterized.class)
public class UpdateAgeLabelRolesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long adID;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String apiUserLogin;

    @Parameterized.Parameter(2)
    public String login;

    @Parameterized.Parameter(3)
    public String loginToCreateAd;

    @Parameterized.Parameter(4)
    public AgeLabelEnum oldAgeLabel;

    @Parameterized.Parameter(5)
    public AgeLabelEnum newAgeLabel;

    @Parameterized.Parameter(6)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"установка значения AgeLabel от имени клиента", AdsLogins.CLIENT, AdsLogins.CLIENT,
                        AdsLogins.CLIENT,
                        null,
                        AgeLabelEnum.MONTHS_1,
                        ExpectedResult.warnings(new Notification(6000, Api5ErrorDetails.NOT_ALLOWED_TO_UPDATE_AGE_LABEL))},
                {"изменение значения AgeLabel от имени клиента", AdsLogins.CLIENT, AdsLogins.CLIENT,
                        AdsLogins.CLIENT,
                        AgeLabelEnum.MONTHS_0,
                        AgeLabelEnum.MONTHS_1,
                        ExpectedResult.success()},

                {"установка значения AgeLabel от имени агенства", AdsLogins.AGENCY, AdsLogins.SUBCLIENT,
                        AdsLogins.AGENCY,
                        null,
                        AgeLabelEnum.MONTHS_1,
                        ExpectedResult.warnings(new Notification(6000, Api5ErrorDetails.NOT_ALLOWED_TO_UPDATE_AGE_LABEL))},
                {"изменение значения AgeLabel от имени агенства", AdsLogins.AGENCY, AdsLogins.SUBCLIENT,
                        AdsLogins.AGENCY,
                        AgeLabelEnum.MONTHS_0,
                        AgeLabelEnum.MONTHS_1,
                        ExpectedResult.success()},

                {"установка значения AgeLabel от имени супера", Logins.SUPER_LOGIN, AdsLogins.CLIENT,
                        AdsLogins.CLIENT,
                        null,
                        AgeLabelEnum.MONTHS_1,
                        ExpectedResult.success()},
                {"изменение значения AgeLabel от имени супера", Logins.SUPER_LOGIN, AdsLogins.CLIENT,
                        AdsLogins.CLIENT,
                        AgeLabelEnum.MONTHS_0,
                        AgeLabelEnum.MONTHS_1,
                        ExpectedResult.success()},

                {"установка значения AgeLabel от имени саппорта", Logins.SUPPORT, AdsLogins.CLIENT,
                        Logins.SUPER_LOGIN,
                        null,
                        AgeLabelEnum.MONTHS_1,
                        ExpectedResult.success()},
                {"изменение значения AgeLabel от имени саппорта", Logins.SUPPORT, AdsLogins.CLIENT,
                        Logins.SUPER_LOGIN,
                        AgeLabelEnum.MONTHS_0,
                        AgeLabelEnum.MONTHS_1,
                        ExpectedResult.success()},
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createAd() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginToCreateAd);

        api.as(loginToCreateAd); // Не можем создать кампанию от имени саппорта
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, login);
        adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID, login);

        api.as(Logins.SUPER_LOGIN);
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(
                new AdUpdateItemMap().withId(adID)
                        .withTextAd(new TextAdUpdateMap().defaultAd().withAgeLabel(oldAgeLabel))),
                login);

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(apiUserLogin);
        api.as(apiUserLogin);
    }

    @Test
    public void updateAgeLabel() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adID)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withAgeLabel(newAgeLabel))),
                login,
                expectedResult);
    }
}
