package ru.yandex.autotests.direct.api.ads.update.textad;

import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AgeLabelEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.api.ads.AdsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 27.04.15.
 * https://st.yandex-team.ru/TESTIRT-5113
 *
 * Updated by samedy on 18.12.15
 * https://st.yandex-team.ru/TESTIRT-8062
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Stories(AdsStories.TEXT_AD)
@Description("Изменение значения поля AgeLabel при обновлении текстового объявления")
@RunWith(Parameterized.class)
public class UpdateAgeLabelYearsTest {

    //DIRECT-49103

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adID;

    @Parameterized.Parameter(0)
    public AgeLabelEnum ageLabel;

    @Parameterized.Parameters(name = "AgeLabel = {0}")
    public static Collection<Object[]> data() {
        return asList(
                new Object[]{AgeLabelEnum.AGE_0},
                new Object[]{AgeLabelEnum.AGE_6},
                new Object[]{AgeLabelEnum.AGE_12},
                new Object[]{AgeLabelEnum.AGE_16},
                new Object[]{AgeLabelEnum.AGE_18}
        );
    }

    @BeforeClass
    public static void createAd() {
        api.as(Logins.SUPER_LOGIN);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, LOGIN);
        adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID, LOGIN);
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(
                new AdUpdateItemMap().withId(adID)
                        .withTextAd(new TextAdUpdateMap().defaultAd().withAgeLabel(AgeLabelEnum.AGE_6))),
                LOGIN);

        api.as(LOGIN);
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void updateAgeLabelValue() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adID)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withAgeLabel(ageLabel))),
                ExpectedResult.success(adID));

        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adID))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.AGE_LABEL));
        AgeLabelEnum actualAgeLabel = response.getAds().get(0).getAgeLabel().getValue();
        assertThat("поле AgeLabel сохранилось верно", actualAgeLabel, equalTo(ageLabel));
    }
}
