package ru.yandex.autotests.direct.api.ads.update.textad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerDisplayHrefsRecord;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка обнуления поля DisplayUrlPath")
@Issue("https://st.yandex-team.ru/DIRECT-70017")
@RunWith(Parameterized.class)
public class UpdateDisplayUrlPathNilTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long adId;
    private static Long vCardId;

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;

    @Parameterized.Parameter(0)
    public ProtocolType protocol;


    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {ProtocolType.JSON},
                {ProtocolType.SOAP}
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
    }
    @Before
    public void addAd(){
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withVCardId(vCardId)
                                        .withDisplayUrlPath(TextAdAddMap.DEFAULT_DISPLAY_URL_PATH)
                        )
                        .withAdGroupId(adGroupId)), ExpectedResult.success());
        adId = response.getAddResults().get(0).getId();
    }

    @Test
    public void deleteDisplayPathUrl() {
        api.protocol(protocol).userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(
                                        new TextAdUpdateMap().withDisplayUrlPath(null))),
                ExpectedResult.success());

        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId)
                )
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.DISPLAY_URL_PATH));
        assertThat("поле затерлось верно",
                getResponse.getAds().get(0).getTextAd().getDisplayUrlPath().getValue(),
                nullValue());
    }

    @Test
    public void checkInDBAfterUpdate(){
        api.protocol(protocol).userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(
                                        new TextAdUpdateMap().withDisplayUrlPath(null))),
                ExpectedResult.success());

        BannerDisplayHrefsRecord bannerDisplayHrefs = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(AdsLogins.CLIENT).bannerDisplayHrefsSteps().getBannerDisplayHrefs(adId);
        assertThat("верно записалось поле DisplayUrlPath в базу", bannerDisplayHrefs, nullValue());
    }
}

