package ru.yandex.autotests.direct.api.ads.update.textad;

import com.yandex.direct.api.v5.ads.AddResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerDisplayHrefsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 07.04.16.
 * https://st.yandex-team.ru/TESTIRT-8931
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Общие проверки поля DisplayUrlPath")
@Issue("https://st.yandex-team.ru/DIRECT-52434")
public class UpdateDisplayUrlPathTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static AddResponse response;
    private static Long adId;
    private static Long vCardId;

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;

    @BeforeClass
    public static void initTest() {
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(AdsLogins.CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId.longValue());
    }
    @Before
    public void addAd(){
        response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withVCardId(vCardId)
                                        .withDisplayUrlPath(TextAdAddMap.DEFAULT_DISPLAY_URL_PATH)
                        )
                        .withAdGroupId(adGroupId)), ExpectedResult.success());
        adId = response.getAddResults().get(0).getId();
    }

    @Test
    @Issue("DIRECT-53046")
    public void addWithPathAndWithoutHref() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withTextAd(
                                        new TextAdUpdateMap()
                                        .withHref(null)
                                )
                                .withId(adId)),
                ExpectedResult.errors(new Notification(6000, Api5ErrorDetails.DISPLAY_URL_PATH_WITHOUT_HREF)));
    }

    @Test
    public void checkInDBAfterUpdate(){
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(
                                        new TextAdUpdateMap().withDisplayUrlPath(TextAdAddMap.DEFAULT_DISPLAY_URL_PATH + "updated"))),
                ExpectedResult.success());

        BannerDisplayHrefsRecord bannerDisplayHrefs = jooqDbSteps.bannerDisplayHrefsSteps().getBannerDisplayHrefs(adId);
        assertThat("верно записалось поле DisplayUrlPath в базу", bannerDisplayHrefs.getDisplayHref(), equalTo(TextAdAddMap.DEFAULT_DISPLAY_URL_PATH + "updated"));
    }
}
