package ru.yandex.autotests.direct.api.ads.update.textad;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by ginger on 09.04.16.
 * https://st.yandex-team.ru/TESTIRT-8931
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка валидации поля DisplayUrlPath. Негативные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-52434")
@RunWith(Parameterized.class)
public class UpdateDisplayUrlPathValidationNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    private static Long adId;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String path;

    @Parameterized.Parameter(2)
    public Notification expectedNotification;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        String pathWithSpecificSymbol = "hello!world";
        String emptyString = "";
        String stringWithSpace = " ";
        String doubleDash = "--";
        String doubleSlash = "//";
        String greaterThanMaxLengthPath = randomAlphabetic(TextAdAddMap.MAX_DISPLAY_URL_PATH + 1);
        String greaterThanMaxLengthPathWithSpecific = "#"+randomAlphabetic(TextAdAddMap.MAX_DISPLAY_URL_PATH).toLowerCase();

        return Arrays.asList(new Object[][]{
                {"Обновить баннер со ссылкой, содержащей специфичный символ", pathWithSpecificSymbol,
                        new Notification(5002, Api5ErrorDetails.INVALID_SYMBOL_IN_DISPLAY_URL_PATH, "!")},
                {"Обновить баннер со ссылкой, содержащей пустую строку", emptyString,
                        new Notification(5004, Api5ErrorDetailsJava.EMPTY_VALUE, capitalize(TextAdAddMap.DISPLAY_URL_PATH))},
                {"Обновить баннер со ссылкой, содержащей пробел", stringWithSpace,
                        new Notification(5002, Api5ErrorDetails.INVALID_SYMBOL_IN_DISPLAY_URL_PATH, " ")},
                {"Обновить баннер со ссылкой длиной большей, чем " + TextAdAddMap.MAX_DOMAIN_LENGTH, greaterThanMaxLengthPath,
                        new Notification(5001,
                                Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED, capitalize(TextAdAddMap.DISPLAY_URL_PATH), TextAdAddMap.MAX_DISPLAY_URL_PATH)},
                {"Обновить баннер со ссылкой длиной большей, чем " + TextAdAddMap.MAX_DOMAIN_LENGTH + "и с #", greaterThanMaxLengthPathWithSpecific,
                        new Notification(5001,
                                Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED, capitalize(TextAdAddMap.DISPLAY_URL_PATH), TextAdAddMap.MAX_DISPLAY_URL_PATH)},
                {"Создать баннер со ссылкой, содержащей двойное тире", doubleDash,
                        new Notification(5004, Api5ErrorDetails.SPECIFIC_SYMBOLS_MUST_NOT_BE_REPEATED, capitalize(TextAdAddMap.DISPLAY_URL_PATH))},
                {"Создать баннер со ссылкой, содержащей двойной слэш", doubleSlash,
                        new Notification(5004, Api5ErrorDetails.SPECIFIC_SYMBOLS_MUST_NOT_BE_REPEATED, capitalize(TextAdAddMap.DISPLAY_URL_PATH))}
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    public void updateWithDisplayUrlPath() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withTextAd(new TextAdUpdateMap().withDisplayUrlPath(path))
                                .withId(adId)),
                ExpectedResult.errors(expectedNotification));
    }
}
