package ru.yandex.autotests.direct.api.ads.update.textad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 09.04.16.
 * https://st.yandex-team.ru/TESTIRT-8931
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка валидации поля DisplayUrlPath. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-52434")
@RunWith(Parameterized.class)
public class UpdateDisplayUrlPathValidationPositiveTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    private static Long adId;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String path;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        String symbolsPath = "-/№%#";
        String pathWithUpperCases = "deFaultUrL";
        String minDisplayUrlPath = randomAlphabetic(TextAdAddMap.MIN_DISPLAY_URL_PATH).toLowerCase();
        String maxDisplayUrlPath = randomAlphabetic(TextAdAddMap.MAX_DISPLAY_URL_PATH).toLowerCase();
        String templateInDisplayUrlPath = "#"+randomAlphabetic(TextAdAddMap.MAX_DISPLAY_URL_PATH).toLowerCase()+"#";
        String russianPath = "подарки";
        String numericPath = "12345";
        String dashedPath = "hello-world";

        return Arrays.asList(new Object[][]{
                {"Создать баннер с зеленым урлом, в котором допустимые спец.символы", symbolsPath},
                {"Создать баннер с зеленым урлом, в котором символы в разных регистрах", pathWithUpperCases},
                {"Создать баннер с зеленым урлом минимальной длины " + TextAdAddMap.MIN_DOMAIN_LENGTH,
                        minDisplayUrlPath},
                {"Создать баннер с зеленым урлом с максимальной длиной" + TextAdAddMap.MAX_DOMAIN_LENGTH,
                        maxDisplayUrlPath},
                {"Создать баннер с зеленым урлом, содержащим из русских букв", russianPath},
                {"Создать баннер с зеленым урлом, содержащим цифры", numericPath},
                {"Создать баннер с зеленым урлом, содержащим шаблон", templateInDisplayUrlPath},//DIRECT-53705
                {"Создать баннер с зеленым урлом, содержащим дефисы", dashedPath}
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                                .withTextAd(
                                        new TextAdAddMap()
                                                .defaultTextAd()
                                                .withDisplayUrlPath(TextAdAddMap.DEFAULT_DISPLAY_URL_PATH)
                                )
                                .withAdGroupId(adGroupId)
        );
    }

    @Test
    public void updateWithPathAndCheckSave() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withTextAd(new TextAdUpdateMap().withDisplayUrlPath(path))
                                .withId(adId)),
                ExpectedResult.success());
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                    .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                    .withFieldNames(AdFieldEnum.ID)
                    .withTextAdFieldNames(TextAdFieldEnum.DISPLAY_URL_PATH));
        assertThat("зеленый урл баннера сохранился верно", getResponse.getAds(),
                beanDifferV5(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap().withId(adId)
                                        .withTextAd(
                                                new TextAdGetMap()
                                                        .withDisplayUrlPath(path)
                                        ).getBean())));
    }
}
