package ru.yandex.autotests.direct.api.ads.update.textad;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.api.ads.AdsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Stories(AdsStories.TEXT_AD)
@Description("Изменение ссылки с изменением домена должно изменять DomainId в базе")
@Issue("https://st.yandex-team.ru/DIRECT-79390")
public class UpdateHrefAndCheckDomainIdTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String HREF_BEFORE = "http://mail.ru";
    private static final String DOMAIN_BEFORE = "mail.ru";
    private static final String HREF_AFTER = "http://yandex.ru";
    private static final String DOMAIN_AFTER = "yandex.ru";

    private static long adId;
    private static long domainIdBefore;

    @BeforeClass
    public static void createAd() {
        api.as(LOGIN).userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withTextAd(new TextAdAddMap().defaultTextAd().withHref(HREF_BEFORE))
                .withAdGroupId(adGroupId));
        BannersRecord record = jooqSteps().bannersSteps().getBanner(adId);
        assumeThat("у объявления правильный Domain в БД", record.getDomain(), equalTo(DOMAIN_BEFORE));
        domainIdBefore = record.getDomainId();
    }

    @Test
    public void updateHref() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .withHref(HREF_AFTER))),
                ExpectedResult.success());

        BannersRecord record = jooqSteps().bannersSteps().getBanner(adId);

        assumeThat("у объявления обновился Domain в БД", record.getDomain(), equalTo(DOMAIN_AFTER));
        assertThat("у объявления обновился DomainId", record.getDomainId(), not(equalTo(domainIdBefore)));
    }

    private static DirectJooqDbSteps jooqSteps() {
        return api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
    }
}
