package ru.yandex.autotests.direct.api.ads.update.textad;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.api.ads.AdsStories;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 14.04.15.
 * https://st.yandex-team.ru/TESTIRT-5113
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Stories(AdsStories.TEXT_AD)
@Description("Неверные хеши картинок в запросе на обновление текстового объявления")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateInvalidAdImageHashTest {

    private static final String LOGIN = AdsLogins.CLIENT12;
    private static final String ANOTHER_LOGIN = AdsLogins.CLIENT13;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adID;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String invalidAdImageHash;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(ANOTHER_LOGIN);

        api.as(ANOTHER_LOGIN);
        String[] adImageHashes = api.userSteps.imagesSteps().configLoginImages(LOGIN, ImageType.REGULAR, 6);

        api.as(LOGIN);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        String[] nonexistentAdImageHash = api.userSteps.imagesSteps().configLoginImages(LOGIN, ImageType.REGULAR, 7);
        api.userSteps.imagesSteps().adImageDelete(nonexistentAdImageHash[0]);

        return Arrays.asList(new Object[][]{
                {"некорректный хеш картинки", "11111111"},
                {"удалённый хеш картинки", nonexistentAdImageHash[0]},
                {"чужой хеш картинки", adImageHashes[0]},
        });
    }

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void updateWithInvalidAdImageHash() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adID)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withAdImageHash(invalidAdImageHash))),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)));
    }
}
