package ru.yandex.autotests.direct.api.ads.update.textad;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.api.ads.AdsStories;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.Common.fieldMustBePositiveInteger;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.bothJavaAndPerl;

/**
 * Created by semkagtn on 13.04.15.
 * https://st.yandex-team.ru/TESTIRT-5113
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Stories(AdsStories.TEXT_AD)
@Description("Неверные идентификаторы наборов сайтлинков в запросе на обновление текстового объявления")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateInvalidSitelinksSetIdTest {

    private static final String LOGIN = AdsLogins.CLIENT;
    private static final String ANOTHER_LOGIN = AdsLogins.CLIENT_ELSE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adID;

    @Parameter(0)
    public String description;

    @Parameter(1)
    public long invalidSitelinksSetID;

    @Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(ANOTHER_LOGIN);

        api.as(ANOTHER_LOGIN);
        long anotherSitelinksSetID = api.userSteps.sitelinksSteps().addDefaultSet(1);

        api.as(LOGIN);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        long sitelinksSetID = api.userSteps.sitelinksSteps().addDefaultSet(1);
        long nonexistentSitelinksSetID = sitelinksSetID + 300000;
        long deletedSitelinksSetID = api.userSteps.sitelinksSteps().addDefaultSet(1);
        api.userSteps.sitelinksSteps().delete(deletedSitelinksSetID);

        return Arrays.asList(new Object[][]{
                {"несуществующий идентификатор набора сайтлинков", nonexistentSitelinksSetID,
                        bothJavaAndPerl(8800, Api5ErrorDetails.SITELINKS_SET_NOT_FOUND)},
                {"удалённый идентификатор набора сайтлинков", deletedSitelinksSetID,
                        bothJavaAndPerl(8800, Api5ErrorDetails.SITELINKS_SET_NOT_FOUND)},
                {"чужой идентификатор набора сайтлинков", anotherSitelinksSetID,
                        bothJavaAndPerl(8800, Api5ErrorDetails.SITELINKS_SET_NOT_FOUND)},
        });
    }

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void updateWithInvalidSitelinksSetId() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adID)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withSitelinkSetId(invalidSitelinksSetID))),
                expectedResult);
    }
}
