package ru.yandex.autotests.direct.api.ads.update.textad;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.api.ads.AdsStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 13.04.15.
 * https://st.yandex-team.ru/TESTIRT-5113
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Stories(AdsStories.TEXT_AD)
@Description("Проверка обязательных полей в запросе на обновление текстовых объявлений")
public class UpdateMandatoryFieldsTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adID;

    @BeforeClass
    public static void createAd() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Запрос на обновление текстового объявления без поля Ads.TextAd")
    public void requestWithoutTextAdField() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adID)
                                .withTextAd(null)),
                ExpectedResult.errors(new Notification(5008, Api5ErrorDetailsJava.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                        "TextAd, DynamicTextAd, MobileAppAd, TextImageAd, MobileAppImageAd, TextAdBuilderAd, " +
                                "MobileAppAdBuilderAd, CpmBannerAdBuilderAd, CpcVideoAdBuilderAd, " +
                                "CpmVideoAdBuilderAd, ContentPromotionVideoAd, ContentPromotionCollectionAd, " +
                                "ContentPromotionServiceAd, ContentPromotionEdaAd, SmartAdBuilderAd, " +
                                "MobileAppCpcVideoAdBuilderAd")));
    }

    @Test
    @Description("Запрос на обновление текстового объявления без ссылки Href и визитки VCardId")
    public void requestWithoutHrefAndVCardIdFields() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adID)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withHref(null))),
                JavaOrPerlExpectedResult.expect(6000,
                        Api5ErrorDetails.AD_MUST_CONTAIN_VCARD_OR_MAIN_HREF,
                        Api5ErrorDetailsJava.AD_MUST_CONTAIN_VCARD_OR_MAIN_HREF));
    }
}
