package ru.yandex.autotests.direct.api.ads.update.textad;

import com.yandex.direct.api.v5.general.OperationEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.api.ads.AdsStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 15.04.15.
 * https://st.yandex-team.ru/TESTIRT-5113
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Stories(AdsStories.TEXT_AD)
@Description("Проверка обновления текстового объявления через протокол SOAP")
public class UpdateSoapTest {

    private static final String LOGIN = AdsLogins.CLIENT14;

    private static final String UPDATE_REQUEST = "UpdateRequest";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adID;
    private static long vCardID;
    private static long sitelinkSetID;
    private static String adImageHash;
    private static Long adExtensionId;

    @BeforeClass
    public static void createAd() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.protocol(ProtocolType.JSON);

        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        vCardID = api.userSteps.vCardsSteps().addDefaultVCard(campaignID);
        sitelinkSetID = api.userSteps.sitelinksSteps().addDefaultSet(1);
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        adImageHash = api.userSteps.imagesSteps().configLoginImages(AdsLogins.CLIENT_SHARD2, ImageType.REGULAR, 1)[0];
        adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID);

        api.protocol(ProtocolType.SOAP);
    }

    @Test
    @Description("Валидный запрос на обновление текстового объявления")
    public void validSoapRequest() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adID)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withVCardId(vCardID)
                                        .withSitelinkSetId(sitelinkSetID)
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withOperation(OperationEnum.ADD)
                                                        .withAdExtensionId(adExtensionId)))
                                        .withAdImageHash(adImageHash))),
                ExpectedResult.success(adID));
    }

    @Test
    @Description("Пустой запрос на обновление текстового объявления")
    public void emptyRequest() {
        api.userSteps.adsSteps().expectErrorOnAdsUpdate(new UpdateRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                                capitalize(UpdateRequestMap.ADS)));
    }
}
