package ru.yandex.autotests.direct.api.ads.update.textad;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.general.OperationEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersAdditionsAdditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersAdditionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.direct.db.utils.JooqRecordListDifferMatcher.recordsDiffer;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 09.12.16.
 * https://st.yandex-team.ru/TESTIRT-10642
 */
@Aqua.Test
@Description("Проверка корректности работы метода при наличии дисклеймера у клиента")
@Issue("https://st.yandex-team.ru/DIRECT-59010")
@Features(AdsFeatures.UPDATE)
public class UpdateTextAdDisclaimerTest {
    private static Long disclaimerId;
    private static Long adExtensionId;
    private static Long adExtensionIdElse;
    private static Long campaignId;
    private static Long adGroupId;
    private static String LOGIN = AdsLogins.CLIENT;
    private static Long adId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @BeforeClass
    public static void prepareData() {
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        disclaimerId = jooqDbSteps.bannerAdditionsSteps().saveAdditionsItemDisclaimers(
                        Long.parseLong(User.get(LOGIN).getClientID()),
                        RandomStringUtils.randomAlphanumeric(24));
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15), LOGIN);
        adExtensionIdElse = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15), LOGIN);
        AddResponse textAd = api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(
                                        new TextAdAddMap().defaultTextAd()
                                                .withAdExtensionIds(adExtensionId))
                                .withAdGroupId(adGroupId)),
                LOGIN,
                ExpectedResult.success());
        assumeThat("добавлено 1 объявление", textAd.getAddResults(), hasSize(1));
        adId = textAd.getAddResults().get(0).getId();
        jooqDbSteps.bannerAdditionsSteps().saveBannerAdditions(
                adId,
                disclaimerId,
                BannersAdditionsAdditionsType.disclaimer);

    }

    @Test
    public void addNewCalloutAndRemoveOld() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionIdElse)
                                                                .withOperation(OperationEnum.ADD),
                                                        new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionId)
                                                                .withOperation(OperationEnum.REMOVE))))),
                ExpectedResult.success(adId));

        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(adId);
        BannersAdditionsRecord expectedDisclaimer =
                new BannersAdditionsRecord(adId, disclaimerId, BannersAdditionsAdditionsType.disclaimer, (short) 0);
        BannersAdditionsRecord expectedCallout =
                new BannersAdditionsRecord(adId, adExtensionIdElse, BannersAdditionsAdditionsType.callout, (short) 1);

        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditions, recordsDiffer(Arrays.asList(expectedDisclaimer, expectedCallout)));
    }


    @Test
    public void tryUpdateWithDisclaimerIdInsteadAdExtensionId() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(disclaimerId)
                                                                .withOperation(OperationEnum.ADD))))),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_EXTENSION_NOT_FOUND, disclaimerId)));
    }


    @AfterClass
    public static void deleteDisclaimer(){
        jooqDbSteps.bannerAdditionsSteps().deleteAdditionsItemDisclaimers(disclaimerId);
    }
}
