package ru.yandex.autotests.direct.api.ads.update.textad;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.api.ads.AdsStories;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;

/**
 * Created by semkagtn on 13.04.15.
 * https://st.yandex-team.ru/TESTIRT-5113
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Stories(AdsStories.TEXT_AD)
@Description("Базовые проверки метода Ads.Update для текстового объявления")
@Tag(TagDictionary.TRUNK)
public class UpdateTextAdTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long firstAdID;
    private static long secondAdID;

    private static long anotherGroupAdID;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);

        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        firstAdID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        secondAdID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID);

        long anotherAdGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        anotherGroupAdID = api.userSteps.adsSteps().addDefaultTextAd(anotherAdGroupID);
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Обновить одно текстовое объявление")
    public void updateOneTextAd() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                .withAds(new AdUpdateItemMap()
                        .withId(firstAdID)
                        .withTextAd(new TextAdUpdateMap()
                                .defaultAd()
                                .withText(randomAlphabetic(10)))),
                ExpectedResult.success(firstAdID));
    }

    @Test
    @Description("Обновить два текстовых объявления из одной группы")
    public void updateTwoTextAdsFromOneGroup() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(
                                new AdUpdateItemMap()
                                        .withId(firstAdID)
                                        .withTextAd(new TextAdUpdateMap()
                                                .defaultAd()
                                                .withText(randomAlphabetic(10))),
                                new AdUpdateItemMap()
                                        .withId(secondAdID)
                                        .withTextAd(new TextAdUpdateMap()
                                                .defaultAd()
                                                .withText(randomAlphabetic(10)))),
                ExpectedResult.success(firstAdID), ExpectedResult.success(secondAdID));
    }

    @Test
    @Description("Обновить два текстовых объявления из разных групп")
    public void updateTwoTextAdsFromDifferentGroups() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(
                                new AdUpdateItemMap()
                                        .withId(firstAdID)
                                        .withTextAd(new TextAdUpdateMap()
                                                .defaultAd()
                                                .withText(randomAlphabetic(10))),
                                new AdUpdateItemMap()
                                        .withId(anotherGroupAdID)
                                        .withTextAd(new TextAdUpdateMap()
                                                .defaultAd()
                                                .withText(randomAlphabetic(10)))),
                ExpectedResult.success(firstAdID), ExpectedResult.success(anotherGroupAdID));
    }
}
