package ru.yandex.autotests.direct.api.ads.update.textad;

import java.util.Collection;
import java.util.stream.Collectors;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.api.ads.AdsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.directapi.cases.TextGeoMatchingWithCampLangCases;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.enums.CampaignLanguage;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by buhter on 11.01.16.
 * https://st.yandex-team.ru/TESTIRT-8124
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Stories(AdsStories.TEXT_AD)
@Issue("https://st.yandex-team.ru/DIRECT-49583")
@Description("Различный геотаргетинг и различный язык в тексте текстового объявления в запросе" +
        " на его обновление с указанием страны на кампанию")
@RunWith(Parameterized.class)
public class UpdateTextGeoWithCampLangTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long regionID;

    @Parameterized.Parameter(2)
    public String oldText;

    @Parameterized.Parameter(3)
    public String newText;

    @Parameterized.Parameter(4)
    public CampaignLanguage campLang;

    @Parameterized.Parameter(5)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0} с выставлением языка на кампанию - {4}")
    public static Collection<Object[]> data() {
        return TextGeoMatchingWithCampLangCases.getUpdateCases().stream()
                .map(c -> new Object[]{c.description, c.regionId, c.oldText, c.newText, c.campLang, c.expectedResult})
                .collect(Collectors.toList());
    }

    private static Long campaignID;
    private static int shard;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
    }

    private long adID;

    @Before
    @Step("Подготовка данных для теста")
    public void createAdd() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        CampOptionsRecord campOptions = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampOptionsById(campaignID);
        campOptions.setContentLang(null);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampOptions(campOptions);
        long adGroupID = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .withCampaignId(campaignID)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME)
                        .withRegionIds(regionID));
        adID = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupID)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withText(oldText)));
        campOptions = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampOptionsById(campaignID);
        campOptions.setContentLang(campLang.value());
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampOptions(campOptions);

    }

    @Test
    public void updateAdText() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adID)
                                .withTextAd(new TextAdUpdateMap()
                                        .withText(newText))),
                expectedResult);
    }
}
