package ru.yandex.autotests.direct.api.ads.update.textad;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.api.ads.AdsStories;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.bothJavaAndPerl;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.expect;

/**
 * Created by semkagtn on 14.04.15.
 * https://st.yandex-team.ru/TESTIRT-5113
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Stories(AdsStories.TEXT_AD)
@Description("Валидация текста текстового объявления при его обновлении")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateTextNegativeTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long adID;
    @Rule
    public Trashman trasher = new Trashman(api);
    @Parameterized.Parameter(0)
    public String description;
    @Parameterized.Parameter(1)
    public String text;
    @Parameterized.Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID);

        String textWithTooLongWord = RandomStringUtils.randomAlphabetic(TextAdUpdateMap.MAX_TEXT_WORD_LENGTH + 1);

        return Arrays.asList(new Object[][]{
                {"текст, являющийся пустой строкой", "",
                        bothJavaAndPerl(5000,
                                Api5ErrorDetails.NO_VALUE_IN_FIELD, capitalize(TextAdUpdateMap.TEXT))},

                {"текст длины больше максимальной", randomValidStringOfLength(TextAdUpdateMap.MAX_TEXT_LENGTH + 1),
                        bothJavaAndPerl(5001,
                                Api5ErrorDetailsJava.FIELD_VALUE_SHOULD_NOT_BE_MORE_THAN,
                                capitalize(TextAdUpdateMap.TEXT), TextAdUpdateMap.MAX_TEXT_LENGTH)},

                {"текст, который состоит из нескольких пробелов", "   ",
                        bothJavaAndPerl(5000,
                                Api5ErrorDetails.NO_VALUE_IN_FIELD, capitalize(TextAdAddMap.TEXT))},

                {"текст, который содержит запрещённые символы", "サムライ",
                        expect(5002,
                                Api5ErrorDetails.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD,
                                Api5ErrorDetailsJava.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                                capitalize(DynamicTextAdAddMap.TEXT))},

                {"текст, который содержит слишком длинную непрерывуню последовательность символов", textWithTooLongWord,
                        bothJavaAndPerl(5006,
                                Api5ErrorDetails.FIELD_CANT_CONTAINS_WORDS_OF_LENGTH,
                                TextAdUpdateMap.MAX_TEXT_WORD_LENGTH, capitalize(TextAdUpdateMap.TEXT),
                                textWithTooLongWord)}
        });
    }

    private static String randomValidStringOfLength(int length) {
        int n = TextAdUpdateMap.MAX_TEXT_WORD_LENGTH;
        StringBuilder stringBuilder = new StringBuilder(RandomStringUtils.randomAlphabetic(length));
        for (int i = n; i <= stringBuilder.length(); i += n) {
            stringBuilder.setCharAt(i, ' ');
        }
        return stringBuilder.toString();
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void updateAdText() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adID)
                                .withTextAd(new TextAdUpdateMap()
                                        .withText(text))),
                expectedResult);
    }
}
