package ru.yandex.autotests.direct.api.ads.update.textad;

import com.yandex.direct.api.v5.ads.AddResponse;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerTurbolandingsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.google.common.primitives.Longs.asList;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by adubinkin on 08.04.19.
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Общие проверки поля обновления поля TurboPageId")
@Issue("https://st.yandex-team.ru/DIRECT-85612")
public class UpdateTurboPageIdTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static AddResponse response;
    private static Long adId;
    private static Long turboPageId;
    private static DirectJooqDbSteps jooqSteps;

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    static String client = AdsLogins.CLIENT;

    @BeforeClass
    public static void initTest() {
        jooqSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client);
        long clientId = jooqSteps.usersSteps().getUser(client).getClientid();

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        turboPageId = jooqSteps.turboLandingsSteps().createDefaultTurbolanding(clientId);
    }

    @AfterClass
    public static void deleteTurboPages() {
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).turboLandingsSteps()
                .deleteTurboLandings(asList(turboPageId));
    }

    @Before
    public void addAd() {
        response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                        )
                        .withAdGroupId(adGroupId)), ExpectedResult.success());
        adId = response.getAddResults().get(0).getId();
    }

    @Test
    public void addUnexistingTurboPageId() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withTextAd(
                                        new TextAdUpdateMap().withTurbPageId(123L)
                                )
                                .withId(adId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.TURBO_PAGE_NOT_FOUND)));
    }

    @Test
    public void checkInDbAfterUpdate() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(
                                        new TextAdUpdateMap().withTurbPageId(turboPageId))),
                ExpectedResult.success());

        BannerTurbolandingsRecord bannerTurbolandingsRecord = jooqSteps.bannerTurbolandingsSteps().getBannerTurbolandings(adId).get(0);
        assertThat("поле turboPageId верно записалось в базу", bannerTurbolandingsRecord.getTlId(), beanDiffer(turboPageId));
    }
}
