package ru.yandex.autotests.direct.api.ads.update.textad.calloutsetting;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.general.OperationEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersAdditionsAdditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersAdditionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.adextensions.AdExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.CalloutMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.direct.db.utils.JooqRecordListDifferMatcher.recordsDiffer;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.Common.fieldMustBePositiveInteger;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 15.03.16.
 * https://st.yandex-team.ru/TESTIRT-8642
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка обновления уточнений операцией ADD")
@Issue("https://st.yandex-team.ru/DIRECT-50726")
@Tag(TagDictionary.TRUNK)
public class UpdateCalloutsOperationAddTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adExtensionId;
    private static Long adExtensionIdElse;
    private static Long adGroupId;
    private static Long campaignId;


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        adExtensionIdElse = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
    }

    @Test
    public void addOneCalloutToAdWithoutCallouts() {
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(adExtensionId)
                                                        .withOperation(OperationEnum.ADD))))),
                ExpectedResult.success(adId));

        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(adId);
        BannersAdditionsRecord expectedBannersAdditions =
                new BannersAdditionsRecord(adId, adExtensionId, BannersAdditionsAdditionsType.callout, (short) 1);

        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditions, recordsDiffer(Arrays.asList(expectedBannersAdditions)));
    }

    @Test
    public void addOneCalloutToAdWithCallout() {
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdExtensionIds(adExtensionId)));
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(adExtensionIdElse)
                                                        .withOperation(OperationEnum.ADD))))),
                ExpectedResult.success(adId));

        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(adId);
        BannersAdditionsRecord expectedBannersAdditions =
                new BannersAdditionsRecord(adId, adExtensionId, BannersAdditionsAdditionsType.callout, (short) 1);
        BannersAdditionsRecord expectedBannersAdditionsElse =
                new BannersAdditionsRecord(adId, adExtensionIdElse, BannersAdditionsAdditionsType.callout, (short) 2);

        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditions, recordsDiffer(Arrays.asList(expectedBannersAdditions, expectedBannersAdditionsElse)));
    }

    @Test
    public void addTwoCalloutsToAdWithoutCallouts() {
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionId)
                                                                .withOperation(OperationEnum.ADD),
                                                        new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionIdElse)
                                                                .withOperation(OperationEnum.ADD))))),
                ExpectedResult.success(adId));

        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(adId);
        BannersAdditionsRecord expectedBannersAdditions =
                new BannersAdditionsRecord(adId, adExtensionId, BannersAdditionsAdditionsType.callout, (short) 1);
        BannersAdditionsRecord expectedBannersAdditionsElse =
                new BannersAdditionsRecord(adId, adExtensionIdElse, BannersAdditionsAdditionsType.callout, (short) 2);

        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditions, recordsDiffer(Arrays.asList(expectedBannersAdditions, expectedBannersAdditionsElse)));
    }

    @Test
    public void addOneValidAndOneInvalidCallouts() {
        //DIRECT-52089
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionId)
                                                                .withOperation(OperationEnum.ADD),
                                                        new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(0l)
                                                                .withOperation(OperationEnum.ADD))))),
                fieldMustBePositiveInteger(
                        capitalize(TextAdUpdateMap.CALLOUT_SETTING) + "." +
                                capitalize(AdExtensionSettingMap.AD_EXTENSIONS) + "[2]." +
                                capitalize(AdExtensionSettingItemMap.AD_EXTENSION_ID)));
    }

    @Test
    public void addSeveralSameCallouts() {
        //DIRECT-52146
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionId)
                                                                .withOperation(OperationEnum.ADD),
                                                        new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionId)
                                                                .withOperation(OperationEnum.ADD))))),
                ExpectedResult.errors(new Notification(9802, Api5ErrorDetails.VALUE_CANNOT_BE_PRESENT_IN_FIELD_MORE_THAN_ONCE,
                        adExtensionId,
                        capitalize(TextAdUpdateMap.CALLOUT_SETTING) + "." +
                                capitalize(AdExtensionSettingMap.AD_EXTENSIONS) + "." +
                                capitalize(AdExtensionSettingItemMap.AD_EXTENSION_ID))));
    }

    @Test
    public void addCalloutToAdWithMaxAmountOfCallouts() {
        AdExtensionAddItemMap[] adExtensionAddItemMaps =
                new AdExtensionAddItemMap[TextAdAddMap.MAX_AD_EXTENSION_IDS_IN_AD];
        for (int i = 0; i < TextAdAddMap.MAX_AD_EXTENSION_IDS_IN_AD; i++) {
            adExtensionAddItemMaps[i] = new AdExtensionAddItemMap()
                    .withCallout(new CalloutMap()
                            .withCalloutText(randomAlphabetic(15)));
        }
        List<Long> adExtensionIds = api.userSteps.adExtensionsSteps().addAdExtensions(adExtensionAddItemMaps);
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .defaultTextAd()
                                        .withAdExtensionIds(adExtensionIds.toArray(new Long[]{})))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.success());
        Long id = response.getAddResults().get(0).getId();
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(id)
                                .withTextAd(new TextAdUpdateMap()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(adExtensionId)
                                                        .withOperation(OperationEnum.ADD))))),
                ExpectedResult.errors(
                        new Notification(7000,
                                Api5ErrorDetails.LIMIT_OF_AD_EXTENSIONS_FOR_AD_EXCEEDED,
                                TextAdAddMap.MAX_AD_EXTENSION_IDS_IN_AD)));
    }

    @Test
    public void addMaxAmountOfCalloutsInAd() {
        AdExtensionAddItemMap[] adExtensionAddItemMaps =
                new AdExtensionAddItemMap[TextAdAddMap.MAX_AD_EXTENSION_IDS_IN_AD];
        for (int i = 0; i < TextAdAddMap.MAX_AD_EXTENSION_IDS_IN_AD; i++) {
            adExtensionAddItemMaps[i] = new AdExtensionAddItemMap()
                    .withCallout(new CalloutMap()
                            .withCalloutText(randomAlphabetic(15)));
        }
        List<Long> adExtensionIds = api.userSteps.adExtensionsSteps().addAdExtensions(adExtensionAddItemMaps);
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);

        AdExtensionSettingItemMap[] adExtensionSettingItemMaps =
                new AdExtensionSettingItemMap[TextAdAddMap.MAX_AD_EXTENSION_IDS_IN_AD];
        for (int i = 0; i < TextAdAddMap.MAX_AD_EXTENSION_IDS_IN_AD; i++) {
            adExtensionSettingItemMaps[i] = new AdExtensionSettingItemMap()
                    .withAdExtensionId(adExtensionIds.get(i))
                    .withOperation(OperationEnum.ADD);
        }
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(adExtensionSettingItemMaps)))),
                ExpectedResult.success(adId));
    }

    @Test
    public void addMoreThanMaxAmountOfCalloutsInAd() {
        AdExtensionAddItemMap[] adExtensionAddItemMaps =
                new AdExtensionAddItemMap[TextAdAddMap.MAX_AD_EXTENSION_IDS_IN_AD + 1];
        for (int i = 0; i < TextAdAddMap.MAX_AD_EXTENSION_IDS_IN_AD + 1; i++) {
            adExtensionAddItemMaps[i] = new AdExtensionAddItemMap()
                    .withCallout(new CalloutMap()
                            .withCalloutText(randomAlphabetic(15)));
        }
        List<Long> adExtensionIds = api.userSteps.adExtensionsSteps().addAdExtensions(adExtensionAddItemMaps);
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);

        AdExtensionSettingItemMap[] adExtensionSettingItemMaps =
                new AdExtensionSettingItemMap[TextAdAddMap.MAX_AD_EXTENSION_IDS_IN_AD + 1];
        for (int i = 0; i < TextAdAddMap.MAX_AD_EXTENSION_IDS_IN_AD + 1; i++) {
            adExtensionSettingItemMaps[i] = new AdExtensionSettingItemMap()
                    .withAdExtensionId(adExtensionIds.get(i))
                    .withOperation(OperationEnum.ADD);
        }
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(adExtensionSettingItemMaps)))),
                ExpectedResult.errors(
                        new Notification(7000,
                                Api5ErrorDetails.LIMIT_OF_AD_EXTENSIONS_FOR_AD_EXCEEDED,
                                TextAdAddMap.MAX_AD_EXTENSION_IDS_IN_AD)));
    }

    @Test
    public void addCalloutThatWasAddedBefore() {
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdExtensionIds(adExtensionId)));
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(adExtensionId)
                                                        .withOperation(OperationEnum.ADD))))),
                ExpectedResult.warnings(adId,
                        new Notification(10170, Api5ErrorDetails.AD_EXTENSION_ALREADY_LINKED, adExtensionId)));
    }

    @Test
    public void addCalloutThatWasAddedBeforeAndNewCallout() {
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdExtensionIds(adExtensionId)));
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionIdElse)
                                                                .withOperation(OperationEnum.ADD),
                                                        new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionId)
                                                                .withOperation(OperationEnum.ADD))))),
                ExpectedResult.warnings(adId,
                        new Notification(10170, Api5ErrorDetails.AD_EXTENSION_ALREADY_LINKED, adExtensionId)));

        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(adId);
        BannersAdditionsRecord expectedBannersAdditions =
                new BannersAdditionsRecord(adId, adExtensionId, BannersAdditionsAdditionsType.callout, (short) 1);
        BannersAdditionsRecord expectedBannersAdditionsElse =
                new BannersAdditionsRecord(adId, adExtensionIdElse, BannersAdditionsAdditionsType.callout, (short) 2);

        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditions, recordsDiffer(Arrays.asList(expectedBannersAdditions, expectedBannersAdditionsElse)));
    }

    @Test
    public void addSeveralSameCalloutsAndInvalidId() {
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionId)
                                                                .withOperation(OperationEnum.ADD),
                                                        new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionId)
                                                                .withOperation(OperationEnum.ADD),
                                                        new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(0l)
                                                                .withOperation(OperationEnum.ADD))))),
                ExpectedResult.errors(new Notification(9802, Api5ErrorDetails.VALUE_CANNOT_BE_PRESENT_IN_FIELD_MORE_THAN_ONCE,
                                adExtensionId,
                                capitalize(TextAdUpdateMap.CALLOUT_SETTING) + "." +
                                        capitalize(AdExtensionSettingMap.AD_EXTENSIONS) + "." +
                                        capitalize(AdExtensionSettingItemMap.AD_EXTENSION_ID)),
                        new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                capitalize(TextAdUpdateMap.CALLOUT_SETTING) + "." +
                                        capitalize(AdExtensionSettingMap.AD_EXTENSIONS) + "[3]." +
                                        capitalize(AdExtensionSettingItemMap.AD_EXTENSION_ID))));
    }

    @Test
    public void addCalloutToAdAndCheckStatusBsSynced() {
        //DIRECT-52237
        //DIRECT-52715
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.bannersFakeSteps().setStatusBsSynced(adId, Status.YES);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("объявление синхронизировано с БК", bannerFakeInfo.getStatusBsSynced(), equalTo(Status.YES));
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(adExtensionId)
                                                        .withOperation(OperationEnum.ADD)))
                                )),
                ExpectedResult.success(adId));
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("StatusBsSynced объявления сбросился", bannerFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }
}
