package ru.yandex.autotests.direct.api.ads.update.textad.calloutsetting;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.general.OperationEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersAdditionsAdditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersAdditionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingItemMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.empty;
import static ru.yandex.autotests.direct.db.utils.JooqRecordListDifferMatcher.recordsDiffer;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.Common.fieldMustBePositiveInteger;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 16.03.16.
 * https://st.yandex-team.ru/TESTIRT-8642
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка обновления уточнений операцией REMOVE")
@Issue("https://st.yandex-team.ru/DIRECT-50726")
public class UpdateCalloutsOperationRemoveTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adExtensionId;
    private static Long adExtensionIdElse;
    private static Long adExtensionIdLast;
    private static Long adGroupId;
    private static Long campaignId;


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        adExtensionIdElse = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        adExtensionIdLast = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
    }

    @Test
    public void removeLastCalloutFromAd() {
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdExtensionIds(adExtensionId)));
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(adExtensionId)
                                                        .withOperation(OperationEnum.REMOVE))))),
                ExpectedResult.success(adId));

        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(adId);

        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditions, empty());
    }

    @Test
    public void removeFirstOfTwoCalloutFromAd() {
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdExtensionIds(adExtensionId, adExtensionIdElse)));
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(adExtensionId)
                                                        .withOperation(OperationEnum.REMOVE))))),
                ExpectedResult.success(adId));

        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(adId);
        BannersAdditionsRecord expectedBannersAdditions =
                new BannersAdditionsRecord(adId, adExtensionIdElse, BannersAdditionsAdditionsType.callout, (short) 1);

        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditions, recordsDiffer(Arrays.asList(expectedBannersAdditions)));
    }

    @Test
    public void removeSecondtOfTwoCalloutFromAd() {
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdExtensionIds(adExtensionId, adExtensionIdElse)));
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(adExtensionIdElse)
                                                        .withOperation(OperationEnum.REMOVE))))),
                ExpectedResult.success(adId));


        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(adId);
        BannersAdditionsRecord expectedBannersAdditions =
                new BannersAdditionsRecord(adId, adExtensionId, BannersAdditionsAdditionsType.callout, (short) 1);

        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditions, recordsDiffer(Arrays.asList(expectedBannersAdditions)));
    }

    @Test
    public void removeSecondtOfThreeCalloutFromAd() {
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdExtensionIds(adExtensionId, adExtensionIdElse, adExtensionIdLast)));
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(adExtensionIdElse)
                                                        .withOperation(OperationEnum.REMOVE))))),
                ExpectedResult.success(adId));


        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(adId);
        BannersAdditionsRecord expectedBannersAdditions =
                new BannersAdditionsRecord(adId, adExtensionId, BannersAdditionsAdditionsType.callout, (short) 1);
        BannersAdditionsRecord expectedBannersAdditionsElse =
                new BannersAdditionsRecord(adId, adExtensionIdLast, BannersAdditionsAdditionsType.callout, (short) 2);

        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditions, recordsDiffer(Arrays.asList(expectedBannersAdditions, expectedBannersAdditionsElse)));
    }

    @Test
    public void removeTwoCalloutFromAd() {
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdExtensionIds(adExtensionId, adExtensionIdElse)));
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionId)
                                                                .withOperation(OperationEnum.REMOVE),
                                                        new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionIdElse)
                                                                .withOperation(OperationEnum.REMOVE))))),
                ExpectedResult.success(adId));

        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(adId);

        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditions, empty());
    }

    @Test
    public void removeSeveralSameCallouts() {
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionId)
                                                                .withOperation(OperationEnum.REMOVE),
                                                        new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionId)
                                                                .withOperation(OperationEnum.REMOVE))))),
                ExpectedResult.errors(new Notification(9802, Api5ErrorDetails.VALUE_CANNOT_BE_PRESENT_IN_FIELD_MORE_THAN_ONCE,
                        adExtensionId,
                        capitalize(TextAdUpdateMap.CALLOUT_SETTING) + "." +
                                capitalize(AdExtensionSettingMap.AD_EXTENSIONS) + "." +
                                capitalize(AdExtensionSettingItemMap.AD_EXTENSION_ID))));
    }

    @Test
    public void removeAlreadyRemovedCallout() {
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(adExtensionId)
                                                        .withOperation(OperationEnum.REMOVE))))),
                ExpectedResult.warnings(adId,
                        new Notification(10171, Api5ErrorDetails.AD_EXTENSION_NOT_LINKED, adExtensionId)));
    }

    @Test
    public void removeAlreadyRemovedCalloutAndNotRemovedCallout() {
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdExtensionIds(adExtensionId)));
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionId)
                                                                .withOperation(OperationEnum.REMOVE),
                                                        new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionIdElse)
                                                                .withOperation(OperationEnum.REMOVE))))),
                ExpectedResult.warnings(adId,
                        new Notification(10171, Api5ErrorDetails.AD_EXTENSION_NOT_LINKED, adExtensionIdElse)));

        List<BannersAdditionsRecord> bannersAdditions =
                jooqDbSteps.bannerAdditionsSteps().getBannersAdditionsRecordsByBid(adId);

        assertThat("дополнения правильно привязались к объявлению",
                bannersAdditions, empty());
    }

    @Test
    public void addOneValidAndOneInvalidCallouts() {
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdExtensionIds(adExtensionId)));
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(adExtensionId)
                                                                .withOperation(OperationEnum.REMOVE),
                                                        new AdExtensionSettingItemMap()
                                                                .withAdExtensionId(0l)
                                                                .withOperation(OperationEnum.ADD))))),
                fieldMustBePositiveInteger(
                        capitalize(TextAdUpdateMap.CALLOUT_SETTING) + "." +
                                capitalize(AdExtensionSettingMap.AD_EXTENSIONS) + "[2]." +
                                capitalize(AdExtensionSettingItemMap.AD_EXTENSION_ID)));
    }

    @Test
    public void removeCalloutFromAdAndCheckStatusBsSynced() {
        //DIRECT-52237
        //DIRECT-52715
        Long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdExtensionIds(adExtensionId)));
        api.userSteps.bannersFakeSteps().setStatusBsSynced(adId, Status.YES);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("объявление синхронизировано с БК", bannerFakeInfo.getStatusBsSynced(), equalTo(Status.YES));
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()
                                        .withCalloutSetting(new AdExtensionSettingMap()
                                                .withAdExtensions(new AdExtensionSettingItemMap()
                                                        .withAdExtensionId(adExtensionId)
                                                        .withOperation(OperationEnum.REMOVE))))),
                ExpectedResult.success(adId));
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("StatusBsSynced объявления сбросился", bannerFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }
}
