package ru.yandex.autotests.direct.api.ads.update.textad.videoextension;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.VideoExtensionAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.VideoExtensionUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.Common.fieldMustBePositiveInteger;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.bothJavaAndPerl;

/**
 * Created by ginger on 21.06.17.
 * https://st.yandex-team.ru/DIRECT-65827
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка работы поля CreativeId")
@Issue("https://st.yandex-team.ru/DIRECT-62100")
@RunWith(Parameterized.class)
public class VideoExtensionCreativeIdNegativeTest {
    private static final String LOGIN = AdsLogins.CLIENT;
    private static final Long NEGATIVE_ID = -1L;
    private static final Long ZERO_ID = 0L;
    private static final Long ANOTHER_CLIENT_CREATIVE_ID = 123L;
    private static Long adId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameter(0)
    public VideoExtensionUpdateItemMap videoExtension;

    @Parameter(1)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {new VideoExtensionUpdateItemMap().withCreativeId(NEGATIVE_ID),
                        fieldMustBePositiveInteger(capitalize(VideoExtensionAddItemMap.CREATIVE_ID))},
                {new VideoExtensionUpdateItemMap().withCreativeId(ZERO_ID),
                        fieldMustBePositiveInteger(capitalize(VideoExtensionAddItemMap.CREATIVE_ID))},
                {new VideoExtensionUpdateItemMap().withCreativeId(ANOTHER_CLIENT_CREATIVE_ID),
                        bothJavaAndPerl(8800, Api5ErrorDetails.VIDEO_ADDITION_NOT_FOUND)},
                {new VideoExtensionUpdateItemMap(),
                        bothJavaAndPerl(5008, Api5ErrorDetailsJava.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                                capitalize(VideoExtensionUpdateItemMap.CREATIVE_ID))},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void addCamp() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);

    }

    @Test
    public void updateVideoExtension() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdUpdateMap().withVideoExtension(videoExtension))),
                expectedResult);
    }
}




