package ru.yandex.autotests.direct.api.ads.update.textad.videoextension;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.VideoExtensionUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 21.06.17.

 * https://st.yandex-team.ru/DIRECT-65827
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка работы поля CreativeId")
@Issue("https://st.yandex-team.ru/DIRECT-62100")
public class VideoExtensionCreativeIdPositiveTest {
    private static String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long adId;
    private static Long adGroupId;
    private static Long creativeId;
    private static int shardId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void addCamp(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shardId = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShard(shardId).perfCreativesSteps().saveDefaultVideoCreative(
                        Long.parseLong(User.get(LOGIN).getClientID()), 1L);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);

    }

    @Test
    public void updateAdWithVideoExtension() {
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdUpdateMap().withVideoExtension(creativeId))),
                ExpectedResult.success());
        List<Long> creativeIds = api.userSteps.getDirectJooqDbSteps().useShard(shardId).bannersPerformanceSteps().findCreativeIds(adId);
        assumeThat("получена одна запись", creativeIds, hasSize(1));
        assertThat("получена ожидаемая связка из banner_performance", creativeIds.get(0), equalTo(creativeId));
    }


    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-67588")
    public void updateAdWithVideoExtensionEqualNull() {
        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withVideoExtension(creativeId))
                        .withAdGroupId(adGroupId)
        );
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdUpdateMap().withVideoExtension(new VideoExtensionUpdateItemMap().withCreativeId(null)))),
                ExpectedResult.success());
        List<Long> creativeIds = api.userSteps.getDirectJooqDbSteps().useShard(shardId).bannersPerformanceSteps().findCreativeIds(adId);
        assertThat("запись отсутствует", creativeIds, hasSize(0));
    }

    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-68098")
    public void checkNotRemoveVideoAfterUpdateAd() {
        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withVideoExtension(creativeId))
                        .withAdGroupId(adGroupId)
        );
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdUpdateMap())),
                ExpectedResult.success());
        List<Long> creativeIds = api.userSteps.getDirectJooqDbSteps().useShard(shardId).bannersPerformanceSteps().findCreativeIds(adId);
        assumeThat("получена одна запись", creativeIds, hasSize(1));
        assertThat("получена ожидаемая связка из banner_performance", creativeIds.get(0), equalTo(creativeId));
    }
}



