package ru.yandex.autotests.direct.api.ads.update.textadbuilderad;


import java.util.Arrays;
import java.util.Collection;

import org.glassfish.gmbal.Description;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdBuilderAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * https://st.yandex-team.ru/DIRECT-71573
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка валидации типа креатива (creative_type из ppc.perf_creatives)")
@Issue("https://st.yandex-team.ru/DIRECT-58369")
@RunWith(Parameterized.class)
public class UpdateTextAdBuilderAdCreativeTypeTest {
    private static String LOGIN = AdsLogins.CLIENT;
    private static Long adId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long creativeIdForUpdate;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Long videoCreativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN).perfCreativesSteps().saveDefaultVideoCreative(
                        Long.parseLong(User.get(LOGIN).getClientID()), 1L);
        Long performanceCreativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN).perfCreativesSteps().saveDefaultPerfCreative(
                        Long.parseLong(User.get(LOGIN).getClientID()));

        Object[][] data = new Object[][]{
                {"creative_type = video_addition", videoCreativeId},
                {"creative_type = performance", performanceCreativeId}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void addCampaign(){
        Long creativeIdForAdd = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN).perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                        Long.parseLong(User.get(LOGIN).getClientID()));
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAdBuilderAd(adGroupId, creativeIdForAdd);
    }

    @Test
    public void updateTextAdBuilderAdWithInvalidCreativeType() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(
                        new AdUpdateItemMap()
                                .withTextAdBuilderAd(
                                        new TextAdBuilderAdUpdateMap().withCreative(creativeIdForUpdate))
                                .withId(adId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CREATIVE_NOT_FOUND))
        );
    }
}
