package ru.yandex.autotests.direct.api.ads.update.textadbuilderad;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdBuilderAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * https://st.yandex-team.ru/DIRECT-71573
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка создания ГО, создаваемого на основе креатива, под разными ролями")
@Issue("https://st.yandex-team.ru/DIRECT-58369")
@RunWith(Parameterized.class)
public class UpdateTextAdBuilderAdRolesTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String apiUserLogin;

    @Parameterized.Parameter(2)
    public String login;

    @Parameterized.Parameter(3)
    public String loginToCreateGroup;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Добавление объявления от имени агенства для субклиента", AdsLogins.AGENCY, AdsLogins.SUBCLIENT_SHARD2,
                        AdsLogins.AGENCY},
                {"Добавление объявления от имени представителя агенства для субклиента", AdsLogins.AGENCY_REP, AdsLogins.SUBCLIENT_SHARD2,
                        AdsLogins.AGENCY_REP}
        });
    }

    private Long adGroupId;
    private Long creativeId;
    private Long adId;

    @Before
    public void createAd() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(apiUserLogin);
        api.as(loginToCreateGroup);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, login);
        creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(login).perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                        Long.parseLong(User.get(login).getClientID()));
        adId = api.userSteps.adsSteps().addDefaultTextAdBuilderAd(adGroupId, creativeId, login);
    }

    @Test
    public void requestUsingLogin() {
        api.as(apiUserLogin);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(
                        new AdUpdateItemMap().withTextAdBuilderAd(
                                new TextAdBuilderAdUpdateMap()
                                        .withHref(TextAdBuilderAdAddMap.DEFAULT_HREF + "update")
                        ).withId(adId)
                ),
                login,
                ExpectedResult.success()
        );
    }
}
