package ru.yandex.autotests.direct.api.ads.update.textimagead;

import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsHrefValidationHelper;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.expect;

/**
 * Created by gerdler on 13.07.16.
 * https://st.yandex-team.ru/TESTIRT-9322
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка валидации поля Href. Негативные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-54754")
@RunWith(Parameterized.class)
public class UpdateTextImageAdHrefValidationNegativeTest {
    private static String client = AdsLogins.CLIENT46;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId;

    @Parameter(0)
    public String description;

    @Parameter(1)
    public String href;

    @Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        Collection<Object[]> data = AdsHrefValidationHelper
                .getHrefDataForNegativeParameterized("Заменить текущую ссылку в баннере ссылкой");
        data.add(new Object[]{"Заменить текущую ссылку в баннере пустой ссылкой", "",
                expect(5003, Api5ErrorDetails.EMPTY_HREF, Api5ErrorDetailsJava.EMPTY_HREF)});
        data.add(new Object[]{"Заменить текущую ссылку в баннере ссылкой, состоящей из пробелов", "   ",
                expect(5003, Api5ErrorDetails.EMPTY_HREF, Api5ErrorDetailsJava.EMPTY_HREF)});
        return data;
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        String adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(6);
        adId = api.userSteps.adsSteps().addDefaultTextImageAd(adGroupId, adImageHash);
    }

    @Test
    public void updateWithHref() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withTextImageAd(new TextImageAdUpdateMap().withHref(href))
                                .withId(adId)),
                expectedResult);
    }

}
