package ru.yandex.autotests.direct.api.ads.update.textimagead;

import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsHrefValidationHelper;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * Created by gerdler on 13.07.16.
 * https://st.yandex-team.ru/TESTIRT-9322
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка валидации поля Href. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-54754")
@RunWith(Parameterized.class)
public class UpdateTextImageAdHrefValidationPositiveTest {
    static String client = AdsLogins.CLIENT45;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId;
    private static DirectJooqDbSteps dbSteps;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String href;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return AdsHrefValidationHelper.getHrefDataForPositiveParameterized("Заменить текущую ссылку в баннере ссылкой");
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        String adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(6);
        dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(client);
        adId = api.userSteps.adsSteps().addDefaultTextImageAd(adGroupId, adImageHash);
   }

    @Test
    public void updateWithHrefAndCheckSave() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                .withAds(new AdUpdateItemMap()
                        .withTextImageAd(new TextImageAdUpdateMap().withHref(href))
                        .withId(adId)), ExpectedResult.success());
        assertThat("ссылка баннера обновилась верно", dbSteps.bannersSteps().getBanner(adId).getHref(), equalTo(href));
    }

}
