package ru.yandex.autotests.directapi.agencyclients.add;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.agencyclients.AddResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.agencyclients.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AgencyClientsFeatures.ADD)
@Description("Проверка прав доступа")
@Issue("https://st.yandex-team.ru/DIRECT-65272")
@RunWith(Parameterized.class)
public class CheckRightsPositiveTest {
    public static final String LOGIN_PREFIX = "agency-clients-role-pos";
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operatorLogin;

    @Parameterized.Parameter(2)
    public String agencyLogin;

    @Parameterized.Parameters(name = "{0} (operatorLogin = {1}, agencyLogin = {2})")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][]{
                {"Главный представитель агентства может создавать субклиентов",
                        AgencyClientsLogins.AGENCY_RUB, AgencyClientsLogins.AGENCY_RUB},
                {"Главный представитель агентства может создавать субклиентов, от представителя",
                        AgencyClientsLogins.AGENCY_RUB, AgencyClientsLogins.AGENCY_RUB_REP1},
                {"Менеджер агентства может создавать субклиентов агентства",
                        AgencyClientsLogins.MANAGER_DEFAULT, AgencyClientsLogins.AGENCY_RUB},
        });
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void clear() {
        api.as(operatorLogin);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operatorLogin);
        api.userSteps.clientFakeSteps().enableToCreateSubClients(agencyLogin);
    }

    @Test
    public void rolesTest() {
        String loginToAdd = AddRequestMap.generateLogin(LOGIN_PREFIX);
        AddResponse response = api.userSteps.agencyClientsStepsV5().agencyClientsAdd(
                new AddRequestMap().withDefault(loginToAdd),
                agencyLogin);
        assertThat("полученные поля совпадают с ожидаемыми", response.getLogin(), equalTo(loginToAdd));
    }
}
