package ru.yandex.autotests.directapi.agencyclients.add;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.agencyclients.AddResponse;
import com.yandex.direct.api.v5.general.CurrencyEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ClientsOptionsRecord;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.agencyclients.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.nullValue;
import static org.hamcrest.Matchers.hasProperty;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.directapi.model.Logins.AGENCY_KZT;
import static ru.yandex.autotests.directapi.model.Logins.AGENCY_USD;
import static ru.yandex.autotests.directapi.model.Logins.SUBCLIENT_KZT;
import static ru.yandex.autotests.directapi.model.Logins.SUBCLIENT_USD;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(AgencyClientsFeatures.ADD)
@Description("Проверка того, что для новых KZT сабклиентов выставляется clients_options.is_using_quasi_currency в 1")
@Issue("https://st.yandex-team.ru/DIRECT-73266")
@RunWith(Parameterized.class)
public class KztSubClientAddQuasicurrencyTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String agencyLogin;

    @Parameterized.Parameter(1)
    public String subclientLoginBase;

    @Parameterized.Parameter(2)
    public CurrencyEnum currency;

    @Parameterized.Parameter(3)
    public int expectedQuasiCurrency;

    @Before
    public void initTestCase() {
        api.as(agencyLogin).userSteps.clientFakeSteps().enableToCreateSubClients(agencyLogin);
    }

    @Parameterized.Parameters(name = "agencyLogin: {0}, subclientLoginBase: {1}, currency: {2})")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][]{
                {AGENCY_KZT, SUBCLIENT_KZT, CurrencyEnum.KZT, 1},
                {AGENCY_USD, SUBCLIENT_USD, CurrencyEnum.USD, 0}
        });
    }

    @Test
    public void testQuasicurrency() {
        String login = AddRequestMap.generateLogin(subclientLoginBase);

        AddRequestMap requestParams = new AddRequestMap()
                .withDefault(login)
                .withCurrency(currency);
        AddResponse response =
                api.userSteps.agencyClientsStepsV5().agencyClientsAdd(requestParams);

        assumeThat("добавление субклиента прошло успешно", response,
                hasProperty("clientId", not(nullValue())));

        api.userSteps.getDirectJooqDbSteps().useShardForLogin(login);
        ClientsOptionsRecord clientsOptions = api.userSteps.getDirectJooqDbSteps().clientsOptionsSteps().getClientOptions(response.getClientId());
        assertThat("корректность выставления is_using_quasi_currency", clientsOptions.getIsUsingQuasiCurrency(), is(expectedQuasiCurrency));
    }
}
