package ru.yandex.autotests.directapi.agencyclients.add;

import com.yandex.direct.api.v5.agencyclients.AddResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsFeatures;
import ru.yandex.autotests.directapi.agencyclients.AgencyClientsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.agencyclients.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.allOf;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.notNullValue;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.hamcrest.Matchers.hasProperty;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;


@Aqua.Test
@Features(AgencyClientsFeatures.ADD)
@Description("Проверка успешного добавления менеджером")
public class ManagerAddTest {
    private static final String AGENCY_LOGIN = AgencyClientsLogins.AGENCY_RUB;
    private static final String SUBCLIENT_LOGIN_BASE = "at-agency-clients-test2";

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().enableToCreateSubClients(AGENCY_LOGIN);
    }

    @Test
    public void managerCanCreateAgencySubclient() {
        String login = AddRequestMap.generateLogin(SUBCLIENT_LOGIN_BASE);
        AddResponse response = api.as(AgencyClientsLogins.MANAGER_DEFAULT).userSteps.agencyClientsStepsV5()
                .agencyClientsAdd(new AddRequestMap().withDefault(login), AGENCY_LOGIN);
        assertThat("Ответ возвращается для логина из запроса", response, allOf(
                hasProperty("login", equalTo(login)),
                hasProperty("clientId", not(nullValue()))
        ));
    }

    @Test
    public void agencyCanCreateCampaignForNewSubclientCreatedByManager() {
        String login = AddRequestMap.generateLogin(SUBCLIENT_LOGIN_BASE);
        AddResponse response = api.as(AgencyClientsLogins.MANAGER_DEFAULT).userSteps.agencyClientsStepsV5()
                .agencyClientsAdd(new AddRequestMap().withDefault(login), AGENCY_LOGIN);
        assumeThat("Ответ возвращается для логина из запроса", response,
                hasProperty("login", equalTo(login)));

        Long campaign = api.as(AGENCY_LOGIN).userSteps.addActiveCampaign(login, 1);
        assertThat("Кампания создалась", campaign, notNullValue());
    }
}
